/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.network;

import com.heaser.pipeconnector.utils.GeneralUtils;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class UpdateDepthPacket {
    public int depth;

    public UpdateDepthPacket(int depth) {
        this.depth = depth;
    }

    public UpdateDepthPacket(FriendlyByteBuf buf) {
        this.depth = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.depth);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            if (!GeneralUtils.isHoldingPipeConnector((Player)sender)) {
                return;
            }
            ItemStack item = sender.m_21205_();
            CompoundTag tag = item.m_41698_("pipe_connector");
            tag.m_128405_("Depth", this.depth);
        });
        ctx.get().setPacketHandled(true);
    }
}

