/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils;

import com.heaser.pipeconnector.constants.TagKeys;
import com.heaser.pipeconnector.items.PipeConnectorItem;
import java.time.LocalDateTime;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class GeneralUtils {
    public static boolean isServerSide(Level level) {
        return !level.m_5776_();
    }

    public static ItemStack heldPipeConnector(Player player) {
        if (GeneralUtils.isHoldingPipeConnector(player)) {
            return player.m_21120_(InteractionHand.MAIN_HAND);
        }
        return null;
    }

    public static boolean isHoldingPipeConnector(Player player) {
        return player.m_21120_(InteractionHand.MAIN_HAND) != ItemStack.f_41583_ && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof PipeConnectorItem;
    }

    public static boolean isNotBreakable(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60800_((BlockGetter)level, pos) == -1.0f && !level.m_8055_(pos).m_204336_(TagKeys.UNBREAKABLE_BLOCKS);
    }

    public static boolean isVoidableBlock(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(TagKeys.VOIDABLE_BLOCKS);
    }

    public static boolean isPipeBlock(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(TagKeys.PIPE_BLOCK);
    }

    public static boolean isOffhandItemAvoidable(Level level, BlockPos pos, Player player) {
        return level.m_8055_(pos).m_60734_().m_5456_() == player.m_21206_().m_41720_().m_5456_();
    }

    public static boolean isPlaceableBlock(Player player) {
        return player.m_21206_().m_204117_(TagKeys.PLACEABLE_ITEMS);
    }

    public static boolean hasInventoryCapabilities(Level level, BlockPos pos) {
        return level.m_7702_(pos) != null && Objects.requireNonNull(level.m_7702_(pos)).getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
    }

    public static boolean isAprilFoolsDay() {
        LocalDateTime now = LocalDateTime.now();
        return now.getMonthValue() == 4 && now.getDayOfMonth() == 1;
    }
}

