/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.utils;

import com.heaser.pipeconnector.config.PipeConnectorConfig;
import com.heaser.pipeconnector.constants.BridgeType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TagUtils {
    public static int getDepthFromStack(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        if (tag.m_128425_("Depth", 3)) {
            return tag.m_128451_("Depth");
        }
        return 0;
    }

    public static void setDepthToStack(ItemStack stack, int depth) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        if (depth < 0) {
            depth = (Integer)PipeConnectorConfig.MAX_DEPTH.get();
        } else if (depth > (Integer)PipeConnectorConfig.MAX_DEPTH.get()) {
            depth = 0;
        }
        tag.m_128405_("Depth", depth);
    }

    public static void setStartPositionAndDirection(ItemStack stack, Direction direction, BlockPos startPos) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        tag.m_128344_("StartDirection", direction != null ? (byte)direction.m_122411_() : (byte)-1);
        tag.m_128405_("StartX", startPos.m_123341_());
        tag.m_128405_("StartY", startPos.m_123342_());
        tag.m_128405_("StartZ", startPos.m_123343_());
    }

    public static BlockPos getStartPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        if (!(tag.m_128441_("StartX") && tag.m_128441_("StartY") && tag.m_128441_("StartZ"))) {
            return null;
        }
        int x = tag.m_128451_("StartX");
        int y = tag.m_128451_("StartY");
        int z = tag.m_128451_("StartZ");
        return new BlockPos(x, y, z);
    }

    public static BlockPos getRelativeStartPosition(ItemStack stack) {
        BlockPos startPos = TagUtils.getStartPosition(stack);
        if (startPos == null) {
            return null;
        }
        Direction startDirection = TagUtils.getStartDirection(stack);
        if (startDirection != null) {
            return startPos.m_121945_(startDirection);
        }
        return startPos;
    }

    public static BlockPos getRelativeEndPosition(ItemStack stack) {
        BlockPos endPos = TagUtils.getEndPosition(stack);
        if (endPos == null) {
            return null;
        }
        Direction endDirection = TagUtils.getEndDirection(stack);
        if (endDirection != null) {
            return endPos.m_121945_(endDirection);
        }
        return endPos;
    }

    @Nullable
    public static Direction getStartDirection(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        byte directionByte = tag.m_128445_("StartDirection");
        if (directionByte != -1) {
            return Direction.m_122376_((int)directionByte);
        }
        return null;
    }

    public static void setEndPositionAndDirection(ItemStack stack, Direction direction, BlockPos endPos) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        tag.m_128344_("EndDirection", direction != null ? (byte)direction.m_122411_() : (byte)-1);
        tag.m_128405_("EndX", endPos.m_123341_());
        tag.m_128405_("EndY", endPos.m_123342_());
        tag.m_128405_("EndZ", endPos.m_123343_());
    }

    public static BlockPos getEndPosition(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        if (!(tag.m_128441_("EndX") && tag.m_128441_("EndY") && tag.m_128441_("EndZ"))) {
            return null;
        }
        int x = tag.m_128451_("EndX");
        int y = tag.m_128451_("EndY");
        int z = tag.m_128451_("EndZ");
        return new BlockPos(x, y, z);
    }

    @Nullable
    public static Direction getEndDirection(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        byte directionByte = tag.m_128445_("EndDirection");
        if (directionByte != -1) {
            return Direction.m_122376_((int)directionByte);
        }
        return null;
    }

    public static String getDimension(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        return tag.m_128461_("DimensionName");
    }

    public static void setDimension(ItemStack stack, String dimensionName) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        tag.m_128359_("DimensionName", dimensionName);
    }

    public static BridgeType getBridgeType(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        if (tag.m_128425_("BridgeType", 8)) {
            return BridgeType.valueOf(tag.m_128461_("BridgeType"));
        }
        return BridgeType.DEFAULT;
    }

    public static void setBridgeType(ItemStack stack, BridgeType bridgeType) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        tag.m_128359_("BridgeType", bridgeType.toString());
    }

    public static boolean getUtilizeExistingPipes(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        if (tag.m_128425_("UtilizeExistingPipes", 1)) {
            return tag.m_128471_("UtilizeExistingPipes");
        }
        return false;
    }

    public static void setUtilizeExistingPipes(ItemStack stack, boolean utilizeExistingPipes) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        tag.m_128379_("UtilizeExistingPipes", utilizeExistingPipes);
    }

    public static boolean getPreventInventoryBlockBreaking(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        if (tag.m_128425_("PreventInventoryBlockBreaking", 1)) {
            return tag.m_128471_("PreventInventoryBlockBreaking");
        }
        return true;
    }

    public static void setPreventInventoryBlockBreaking(ItemStack stack, boolean shouldBreakInventoryBlocks) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        tag.m_128379_("PreventInventoryBlockBreaking", shouldBreakInventoryBlocks);
    }

    public static void resetPositionAndDirectionTags(ItemStack stack, Player player, boolean shouldShowMessage) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        tag.m_128473_("StartDirection");
        tag.m_128473_("StartX");
        tag.m_128473_("StartY");
        tag.m_128473_("StartZ");
        tag.m_128473_("EndDirection");
        tag.m_128473_("EndX");
        tag.m_128473_("EndY");
        tag.m_128473_("EndZ");
        if (shouldShowMessage) {
            player.m_5661_((Component)Component.m_237115_((String)"item.pipe_connector.message.resettingPositions"), true);
        }
    }

    public static void setCustomModelData(ItemStack stack, boolean useCustomModelData) {
        if (useCustomModelData) {
            CompoundTag tag = stack.m_41698_("pipe_connector");
            tag.m_128405_("CustomModelData", 1);
        } else {
            CompoundTag tag = stack.m_41698_("pipe_connector");
            tag.m_128405_("CustomModelData", 0);
        }
    }

    public static void setCustomModelData(CompoundTag tag, boolean useCustomModelData) {
        if (useCustomModelData) {
            tag.m_128405_("CustomModelData", 1);
        } else {
            tag.m_128405_("CustomModelData", 0);
        }
    }

    public static int getCustomModelData(ItemStack stack) {
        CompoundTag tag = stack.m_41698_("pipe_connector");
        if (tag.m_128425_("CustomModelData", 3)) {
            return tag.m_128451_("CustomModelData");
        }
        return 0;
    }
}

