/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.seamless_loading_screen;

import com.minenash.seamless_loading_screen.ScreenshotLoader;
import com.minenash.seamless_loading_screen.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.slf4j.Logger;

public class FadeScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int fadeFrames;
    private int frames;
    private Consumer<Boolean> callback;
    private boolean done;

    public FadeScreen(int totalFrames, int fadeFrames) {
        super((Component)Component.m_237115_((String)"seamless_loading_screen.screen.loading_chunks"));
        this.fadeFrames = Math.min(totalFrames, fadeFrames);
        this.frames = totalFrames;
    }

    public FadeScreen then(Consumer<Boolean> callback) {
        this.callback = callback;
        return this;
    }

    public void m_7861_() {
        this.markDone(true);
        super.m_7861_();
    }

    protected void m_7856_() {
        if (Config.get().playSoundEffect) {
            ResourceLocation id = ResourceLocation.m_135820_((String)Config.get().soundEffect);
            if (id != null) {
                SoundEvent soundEvent = BuiltInRegistries.f_256894_.m_6612_(id).orElse(SoundEvents.f_11894_);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)soundEvent, (float)Config.get().soundPitch, (float)Config.get().soundVolume));
            } else {
                LOGGER.error("[SeamlessLoadingScreen]: Unable to parse the above SoundEffect due to it not being a valid Identifier. [Value: {}]", (Object)Config.get().soundEffect);
            }
        }
    }

    private void markDone(boolean forceClosed) {
        if (this.done) {
            return;
        }
        this.done = true;
        this.frames = 0;
        if (this.callback != null) {
            this.callback.accept(forceClosed);
        }
        if (this.callback == null && !forceClosed && this.f_96541_ != null && this.f_96541_.f_91080_ == this) {
            this.f_96541_.m_91152_(null);
        }
    }

    public boolean m_6913_() {
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.frames <= 0 || this.f_96541_ == null) {
            return;
        }
        boolean doFade = this.frames <= this.fadeFrames;
        float alpha = doFade ? Math.min((float)this.frames / (float)this.fadeFrames, 1.0f) : 1.0f;
        Vector4f color = new Vector4f(1.0f, 1.0f, 1.0f, alpha);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172820_);
        if (ScreenshotLoader.loaded) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ScreenshotLoader.SCREENSHOT);
            int w = (int)(ScreenshotLoader.imageRatio * (double)this.f_96544_);
            int h = this.f_96544_;
            int x = this.f_96543_ / 2 - w / 2;
            int y = 0;
            this.loadQuad(context, color, x, y, x + w, y + h);
            if (w < this.f_96543_) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_279548_);
                color.set(0.25f, 0.25f, 0.25f, alpha);
                this.loadQuad(context, color, 0, 0, x, this.f_96544_, 0.0f, 0.0f, (float)x / 32.0f, (float)this.f_96544_ / 32.0f);
                this.loadQuad(context, color, x + w, 0, this.f_96543_, this.f_96544_, (float)(x + w) / 32.0f, 0.0f, (float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f);
            }
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_279548_);
            color.set(0.25f, 0.25f, 0.25f, alpha);
            this.loadQuad(context, color, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, (float)this.f_96543_ / 32.0f, (float)this.f_96544_ / 32.0f);
        }
        ScreenshotLoader.renderAfterEffects(this, context, alpha);
        if (!doFade) {
            context.m_280653_(this.f_96541_.f_91062_, this.f_96539_, this.f_96543_ / 2, 70, 0xFFFFFF);
            String progress = String.valueOf(this.f_96541_.f_91060_.m_109821_());
            context.m_280137_(this.f_96541_.f_91062_, progress, this.f_96543_ / 2, 90, 0xFFFFFF);
        }
        RenderSystem.disableBlend();
        --this.frames;
        if (this.frames == 0) {
            this.markDone(false);
        }
    }

    private void loadQuad(GuiGraphics context, Vector4f color, int x0, int y0, int x1, int y1) {
        this.loadQuad(context, color, x0, y0, x1, y1, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    private void loadQuad(GuiGraphics context, Vector4f color, int x0, int y0, int x1, int y1, float u0, float v0, float u1, float v1) {
        PoseStack stack = context.m_280168_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f modelMat = stack.m_85850_().m_252922_();
        bufferBuilder.m_252986_(modelMat, (float)x0, (float)y1, 0.0f).m_7421_(u0, v1).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
        bufferBuilder.m_252986_(modelMat, (float)x1, (float)y1, 0.0f).m_7421_(u1, v1).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
        bufferBuilder.m_252986_(modelMat, (float)x1, (float)y0, 0.0f).m_7421_(u1, v0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
        bufferBuilder.m_252986_(modelMat, (float)x0, (float)y0, 0.0f).m_7421_(u0, v0).m_85950_(color.x(), color.y(), color.z(), color.w()).m_5752_();
        tessellator.m_85914_();
    }
}

