/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.item;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.structure.Structure;

public interface StructureFinderItem {
    public static final String STRUCTURE_KEY = "structure";
    public static final String POS_KEY = "pos";

    default public int searchRange() {
        return 100;
    }

    @Nullable
    default public BlockPos findAndStoreStructure(ItemStack stack, ServerLevel level, BlockPos searchPos) {
        Pair nearest;
        Optional holder;
        ResourceKey<Structure> structure = this.getStructure(stack);
        if (structure != null && (holder = level.m_9598_().m_175515_(Registries.f_256944_).m_203636_(structure)).isPresent() && (nearest = level.m_7726_().m_8481_().m_223037_(level, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{(Holder)holder.get()}), searchPos, this.searchRange(), false)) != null) {
            BlockPos pos = (BlockPos)nearest.getFirst();
            this.setStructurePos(stack, pos);
            return pos;
        }
        return null;
    }

    @Nullable
    default public ResourceKey<Structure> getStructure(ItemStack stack) {
        String structureS;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(STRUCTURE_KEY, 8) && ResourceLocation.m_135830_((String)(structureS = tag.m_128461_(STRUCTURE_KEY)))) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structureS));
        }
        return null;
    }

    default public void setStructure(ItemStack stack, @Nullable ResourceKey<Structure> structure) {
        CompoundTag tag = stack.m_41784_();
        if (structure == null) {
            tag.m_128473_(STRUCTURE_KEY);
        } else {
            tag.m_128359_(STRUCTURE_KEY, structure.m_135782_().toString());
        }
    }

    @Nullable
    default public BlockPos getStructurePos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(POS_KEY, 4)) {
            return BlockPos.m_122022_((long)tag.m_128454_(POS_KEY));
        }
        return null;
    }

    default public void setStructurePos(ItemStack stack, @Nullable BlockPos structurePos) {
        CompoundTag tag = stack.m_41784_();
        if (structurePos == null) {
            tag.m_128473_(POS_KEY);
        } else {
            tag.m_128356_(POS_KEY, structurePos.m_121878_());
        }
    }
}

