/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.lightningBolt;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import pro.komaru.tridot.client.gfx.lightningBolt.LightningInstance;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.phys.Vec3;

@OnlyIn(value=Dist.CLIENT)
public class LightningEffect {
    private static void addLayeredSegments(Vec3 startPos, int segCount, float scaleMod, float segTaper, Col color, float[] segXOffset, float xOffSum, float[] segZOffset, float zOffSum, float relScale, Matrix4f matrix4f, VertexConsumer builder, float segHeight) {
        for (int layer = 0; layer < 4; ++layer) {
            float red = color.r;
            float green = color.g;
            float blue = color.b;
            float alpha = color.a;
            if (layer == 0) {
                alpha = 1.0f;
                blue = 1.0f;
                green = 1.0f;
                red = 1.0f;
            }
            for (int seg = 0; seg < segCount; ++seg) {
                float pos = (float)seg / (float)segCount;
                float x = segXOffset[seg] - xOffSum * pos;
                float z = segZOffset[seg] - zOffSum * pos;
                float nextPos = (float)(seg + 1) / (float)segCount;
                float nextX = segXOffset[seg + 1] - xOffSum * nextPos;
                float nextZ = segZOffset[seg + 1] - zOffSum * nextPos;
                float layerOffsetA = (0.1f + (float)layer * 0.2f * (1.0f + segTaper)) * relScale * scaleMod;
                float layerOffsetB = (0.1f + (float)layer * 0.2f * (1.0f - segTaper)) * relScale * scaleMod;
                LightningEffect.addSegmentQuad(matrix4f, builder, x, startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, false, true, false, segHeight);
                LightningEffect.addSegmentQuad(matrix4f, builder, x, startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, false, true, true, segHeight);
                LightningEffect.addSegmentQuad(matrix4f, builder, x, startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, true, true, false, true, segHeight);
                LightningEffect.addSegmentQuad(matrix4f, builder, x, startPos.y, z, seg, nextX, nextZ, red, green, blue, alpha, layerOffsetA, layerOffsetB, false, true, false, false, segHeight);
            }
        }
    }

    public static void renderLightningP2PRotate(PoseStack mStack, MultiBufferSource getter, Vec3 startPos, Vec3 endPos, LightningInstance cache) {
        mStack.m_85836_();
        Vec3 dirVec = endPos.cpy();
        dirVec.sub(startPos);
        dirVec.nor();
        mStack.m_252880_(startPos.x, startPos.y, startPos.z);
        mStack.m_252781_(Axis.f_252436_.m_252977_(cache.rotY - 90.0f));
        mStack.m_252781_(Axis.f_252403_.m_252977_(cache.rotX - 90.0f));
        mStack.m_252880_(-startPos.x, -startPos.y, -startPos.z);
        VertexConsumer buffer = getter.m_6299_(RenderType.m_110502_());
        Matrix4f matrix = mStack.m_85850_().m_252922_();
        LightningEffect.addLayeredSegments(startPos, cache.builder.segCount, cache.builder.scaleModifier, cache.builder.segTaper, cache.getColor(), cache.segXOffset, cache.xOffSum, cache.segZOffset, cache.zOffSum, cache.relScale, matrix, buffer, cache.segHeight);
        mStack.m_85849_();
    }

    private static void addSegmentQuad(Matrix4f matrix4f, VertexConsumer builder, float x1, float yOffset, float z1, int segIndex, float x2, float z2, float red, float green, float blue, float alpha, float offsetA, float offsetB, boolean invA, boolean invB, boolean invC, boolean invD, float segHeight) {
        builder.m_252986_(matrix4f, x1 + (invA ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invB ? offsetB : -offsetB)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, x2 + (invA ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invB ? offsetA : -offsetA)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, x2 + (invC ? offsetA : -offsetA), yOffset + ((float)segIndex + 1.0f) * segHeight, z2 + (invD ? offsetA : -offsetA)).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix4f, x1 + (invC ? offsetB : -offsetB), yOffset + (float)segIndex * segHeight, z1 + (invD ? offsetB : -offsetB)).m_85950_(red, green, blue, alpha).m_5752_();
    }
}

