/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static ForgeConfigSpec.ConfigValue<Boolean> BOSSBAR_TITLE;
    public static ForgeConfigSpec.ConfigValue<Boolean> ABILITY_OVERLAY;
    public static ForgeConfigSpec.ConfigValue<Boolean> ITEM_PARTICLE;
    public static ForgeConfigSpec.ConfigValue<Boolean> ITEM_GUI_PARTICLE;
    public static ForgeConfigSpec.ConfigValue<Double> SCREENSHAKE_INTENSITY;
    public static ForgeConfigSpec.ConfigValue<Integer> BOSSBARS_LIMIT;
    public static final ClientConfig INSTANCE;
    public static final ForgeConfigSpec SPEC;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Graphics").push("graphics");
        SCREENSHAKE_INTENSITY = builder.comment("Intensity of screenshake.").defineInRange("screenshakeIntensity", 1.0, 0.0, 10.0);
        ABILITY_OVERLAY = builder.comment("When enabled shows the overlay after using a weapon ability (Default: true)").comment("Reload Resourcepacks after turning this on (F3+T)").define("AbilityOverlay", true);
        BOSSBAR_TITLE = builder.comment("Bossbar boss titles").define("BossbarTitles", true);
        BOSSBARS_LIMIT = builder.comment("Limit of rendered bossbars (Default: 3)").define("BossbarsLimit", (Object)3);
        builder.comment("Particles").push("particles");
        ITEM_PARTICLE = builder.comment("Particles of dropped item.").define("itemParticle", true);
        ITEM_GUI_PARTICLE = builder.comment("Particles of item located in GUI (ex. item in slot)").define("itemGuiParticle", true);
        builder.pop();
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (ClientConfig)specPair.getLeft();
    }
}

