/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.networking.packets;

import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.network.NetworkEvent;
import pro.komaru.tridot.api.render.bossbars.TridotBossBar;
import pro.komaru.tridot.client.BossBarsOverlay;
import pro.komaru.tridot.util.Col;

public record UpdateBossbarPacket(UUID id, Operation operation) {
    static final Operation REMOVE_OPERATION = new Operation(){

        @Override
        public OperationType getType() {
            return OperationType.REMOVE;
        }

        @Override
        public void dispatch(UUID p_178660_, Handler p_178661_) {
            p_178661_.remove(p_178660_);
        }

        @Override
        public void encode(FriendlyByteBuf p_178663_) {
        }
    };

    public static UpdateBossbarPacket decode(FriendlyByteBuf pBuffer) {
        UUID id = pBuffer.m_130259_();
        OperationType operationType = (OperationType)pBuffer.m_130066_(OperationType.class);
        return new UpdateBossbarPacket(id, operationType.reader.apply(pBuffer));
    }

    public static UpdateBossbarPacket createAddPacket(TridotBossBar pEvent) {
        return new UpdateBossbarPacket(pEvent.getId(), new AddOperation(pEvent));
    }

    public static UpdateBossbarPacket createRemovePacket(UUID pId) {
        return new UpdateBossbarPacket(pId, REMOVE_OPERATION);
    }

    public static UpdateBossbarPacket createUpdateProgressPacket(TridotBossBar pEvent) {
        return new UpdateBossbarPacket(pEvent.getId(), new UpdateProgressOperation(pEvent.getHealth(), pEvent.getMaxHealth()));
    }

    public static UpdateBossbarPacket createUpdateNamePacket(TridotBossBar pEvent) {
        return new UpdateBossbarPacket(pEvent.getId(), new UpdateNameOperation(pEvent.getName()));
    }

    public static UpdateBossbarPacket createUpdateStylePacket(TridotBossBar pEvent) {
        return new UpdateBossbarPacket(pEvent.getId(), new UpdateStyleOperation(pEvent.getColor()));
    }

    public static UpdateBossbarPacket createUpdatePropertiesPacket(TridotBossBar pEvent) {
        return new UpdateBossbarPacket(pEvent.getId(), new UpdatePropertiesOperation(pEvent.getType(), pEvent.getTexture(), pEvent.getBossMusic(), pEvent.shouldDarkenScreen(), pEvent.shouldPlayBossMusic(), pEvent.shouldCreateWorldFog(), pEvent.isRainbow(), pEvent.isAboutToDie()));
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.m_130077_(this.id);
        pBuffer.m_130068_((Enum)this.operation.getType());
        this.operation.encode(pBuffer);
    }

    public static void handle(UpdateBossbarPacket pMsg, Supplier<NetworkEvent.Context> context) {
        context.get().setPacketHandled(true);
        BossBarsOverlay.INSTANCE.update(pMsg);
    }

    public void dispatch(Handler pHandler) {
        this.operation.dispatch(this.id, pHandler);
    }

    static interface Operation {
        public OperationType getType();

        public void dispatch(UUID var1, Handler var2);

        public void encode(FriendlyByteBuf var1);
    }

    static enum OperationType {
        ADD(AddOperation::new),
        REMOVE(p_178719_ -> REMOVE_OPERATION),
        UPDATE_PROGRESS(UpdateProgressOperation::new),
        UPDATE_NAME(UpdateNameOperation::new),
        UPDATE_STYLE(UpdateStyleOperation::new),
        UPDATE_PROPERTIES(UpdatePropertiesOperation::new);

        final Function<FriendlyByteBuf, Operation> reader;

        private OperationType(Function<FriendlyByteBuf, Operation> pReader) {
            this.reader = pReader;
        }
    }

    static class AddOperation
    implements Operation {
        public float health;
        public float maxHealth;
        public float r;
        public float g;
        public float b;
        public SoundEvent bossMusic;
        public boolean rainbow;
        public boolean createWorldFog;
        public boolean playBossMusic;
        public boolean darkenScreen;
        protected Component name;
        public ResourceLocation clientBossbarType;
        public ResourceLocation texture;

        public AddOperation(FriendlyByteBuf pBuffer) {
            this(pBuffer.m_130281_(), pBuffer.m_130281_(), pBuffer.m_130238_(), pBuffer.readFloat(), pBuffer.readFloat(), new Col(pBuffer.readFloat(), pBuffer.readFloat(), pBuffer.readFloat()), SoundEvent.m_262856_((ResourceLocation)pBuffer.m_130281_(), (float)16.0f), pBuffer.readBoolean(), pBuffer.readBoolean(), pBuffer.readBoolean(), pBuffer.readBoolean());
        }

        public AddOperation(ResourceLocation type, ResourceLocation texture, Component name, float health, float maxHealth, Col color, SoundEvent bossMusic, boolean darkenScreen, boolean playBossMusic, boolean createWorldFog, boolean rainbow) {
            this.clientBossbarType = type;
            this.texture = texture;
            this.name = name;
            this.health = health;
            this.maxHealth = maxHealth;
            this.r = color.r;
            this.g = color.g;
            this.b = color.b;
            this.bossMusic = bossMusic;
            this.darkenScreen = darkenScreen;
            this.playBossMusic = playBossMusic;
            this.createWorldFog = createWorldFog;
            this.rainbow = rainbow;
        }

        public AddOperation(TridotBossBar pEvent) {
            this.texture = pEvent.getTexture();
            this.clientBossbarType = pEvent.getType();
            this.name = pEvent.getName();
            this.health = pEvent.getHealth();
            this.maxHealth = pEvent.getMaxHealth();
            this.r = pEvent.getColor().r;
            this.g = pEvent.getColor().g;
            this.b = pEvent.getColor().b;
            this.bossMusic = pEvent.getBossMusic();
            this.darkenScreen = pEvent.shouldDarkenScreen();
            this.playBossMusic = pEvent.shouldPlayBossMusic();
            this.createWorldFog = pEvent.shouldCreateWorldFog();
            this.rainbow = pEvent.isRainbow();
        }

        public static AddOperation decode(FriendlyByteBuf pBuffer) {
            return new AddOperation(pBuffer);
        }

        @Override
        public OperationType getType() {
            return OperationType.ADD;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.add(pId, this.clientBossbarType, this.texture, this.name, this.health, this.maxHealth, new Col(this.r, this.g, this.b), this.bossMusic, this.darkenScreen, this.playBossMusic, this.createWorldFog, this.rainbow);
        }

        @Override
        public void encode(FriendlyByteBuf pBuffer) {
            pBuffer.m_130085_(this.clientBossbarType);
            pBuffer.m_130085_(this.texture);
            pBuffer.m_130083_(this.name);
            pBuffer.writeFloat(this.health);
            pBuffer.writeFloat(this.maxHealth);
            pBuffer.writeFloat(this.r);
            pBuffer.writeFloat(this.g);
            pBuffer.writeFloat(this.b);
            pBuffer.m_130085_(this.bossMusic.m_11660_());
            pBuffer.writeBoolean(this.darkenScreen);
            pBuffer.writeBoolean(this.playBossMusic);
            pBuffer.writeBoolean(this.createWorldFog);
            pBuffer.writeBoolean(this.rainbow);
        }
    }

    static class UpdateProgressOperation
    implements Operation {
        public float health;
        public float maxHealth;

        UpdateProgressOperation(float health, float maxHealth) {
            this.health = health;
            this.maxHealth = maxHealth;
        }

        private UpdateProgressOperation(FriendlyByteBuf pBuffer) {
            this.health = pBuffer.readFloat();
            this.maxHealth = pBuffer.readFloat();
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROGRESS;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.updateProgress(pId, this.health, this.maxHealth);
        }

        @Override
        public void encode(FriendlyByteBuf pBuffer) {
            pBuffer.writeFloat(this.health);
            pBuffer.writeFloat(this.maxHealth);
        }
    }

    record UpdateNameOperation(Component name) implements Operation
    {
        private UpdateNameOperation(FriendlyByteBuf pBuffer) {
            this(pBuffer.m_130238_());
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_NAME;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.updateName(pId, this.name);
        }

        @Override
        public void encode(FriendlyByteBuf pBuffer) {
            pBuffer.m_130083_(this.name);
        }
    }

    static class UpdateStyleOperation
    implements Operation {
        public float r;
        public float g;
        public float b;

        UpdateStyleOperation(Col col) {
            this.r = col.r;
            this.g = col.g;
            this.b = col.b;
        }

        private UpdateStyleOperation(FriendlyByteBuf pBuffer) {
            this.r = pBuffer.readFloat();
            this.g = pBuffer.readFloat();
            this.b = pBuffer.readFloat();
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_STYLE;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.updateStyle(pId, new Col(this.r, this.g, this.b));
        }

        @Override
        public void encode(FriendlyByteBuf pBuffer) {
            pBuffer.writeFloat(this.r);
            pBuffer.writeFloat(this.g);
            pBuffer.writeFloat(this.b);
        }
    }

    record UpdatePropertiesOperation(ResourceLocation type, ResourceLocation texture, SoundEvent event, boolean darkenScreen, boolean playMusic, boolean createWorldFog, boolean isRainbow, boolean aboutToDie) implements Operation
    {
        private UpdatePropertiesOperation(FriendlyByteBuf pBuffer) {
            this(pBuffer.m_130281_(), pBuffer.m_130281_(), SoundEvent.m_262856_((ResourceLocation)pBuffer.m_130281_(), (float)16.0f), pBuffer.readBoolean(), pBuffer.readBoolean(), pBuffer.readBoolean(), pBuffer.readBoolean(), pBuffer.readBoolean());
        }

        @Override
        public OperationType getType() {
            return OperationType.UPDATE_PROPERTIES;
        }

        @Override
        public void dispatch(UUID pId, Handler pHandler) {
            pHandler.updateProperties(pId, this.type, this.texture, this.event, this.darkenScreen, this.playMusic, this.createWorldFog, this.isRainbow, this.aboutToDie);
        }

        @Override
        public void encode(FriendlyByteBuf pBuffer) {
            pBuffer.m_130085_(this.type);
            pBuffer.m_130085_(this.texture);
            pBuffer.m_130085_(this.event.m_11660_());
            pBuffer.writeBoolean(this.darkenScreen);
            pBuffer.writeBoolean(this.playMusic);
            pBuffer.writeBoolean(this.createWorldFog);
            pBuffer.writeBoolean(this.isRainbow);
            pBuffer.writeBoolean(this.aboutToDie);
        }
    }

    public static interface Handler {
        default public void add(UUID uuid, ResourceLocation type, ResourceLocation texture, Component pName, float health, float maxHealth, Col color, SoundEvent event, boolean pPlayBossMusic, boolean pDarkenScreen, boolean pCreateWorldFog, boolean isRainbow) {
        }

        default public void remove(UUID uuid) {
        }

        default public void updateProgress(UUID uuid, float health, float maxHealth) {
        }

        default public void updateName(UUID uuid, Component component) {
        }

        default public void updateStyle(UUID uuid, Col color) {
        }

        default public void updateProperties(UUID uuid, ResourceLocation type, ResourceLocation texture, SoundEvent event, boolean darkenSky, boolean shouldPlayBossMusic, boolean createFog, boolean isRainbow, boolean aboutToDie) {
        }
    }
}

