/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.common.registry.block;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import pro.komaru.tridot.common.registry.block.fire.FireBlockHandler;
import pro.komaru.tridot.common.registry.block.fire.FireBlockModifier;
import pro.komaru.tridot.util.Log;

public class TridotBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tridot");
    public static FireBlock fireblock;

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    public static Block[] getBlocks(Class<?> ... blockClasses) {
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!Arrays.stream(blockClasses).anyMatch(b -> b.isInstance(block))) continue;
            matchingBlocks.add(block);
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static Block[] getBlocksExact(Class<?> clazz) {
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        ArrayList<Block> matchingBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!clazz.equals(block.getClass())) continue;
            matchingBlocks.add(block);
        }
        return matchingBlocks.toArray(new Block[0]);
    }

    public static void setFireBlock() {
        fireblock = (FireBlock)Blocks.f_50083_;
        FireBlockHandler.register(new FireBlockModifier());
    }

    public static void axeStrippables(Block block, Block result) {
        AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)block, (Object)result).build();
    }

    public static void fireBlock(Block block, int encouragement, int flammability) {
        fireblock.m_53444_(block, encouragement, flammability);
    }

    public static void weatheringCopper(Block block, Block result) {
        try {
            Field delegateField = WeatheringCopper.f_154886_.getClass().getDeclaredField("delegate");
            delegateField.setAccessible(true);
            java.util.function.Supplier originalWeatheringMapDelegate = (java.util.function.Supplier)delegateField.get(WeatheringCopper.f_154886_);
            Supplier weatheringMapDelegate = () -> TridotBlocks.lambda$weatheringCopper$1((java.util.function.Supplier)originalWeatheringMapDelegate, block, result);
            delegateField.set(WeatheringCopper.f_154886_, weatheringMapDelegate);
        }
        catch (Exception e) {
            Log.error("Failed weathering copper", e);
        }
    }

    public static void waxedCopper(Block block, Block result) {
        java.util.function.Supplier originalWaxableMapSupplier = HoneycombItem.f_150863_;
        HoneycombItem.f_150863_ = Suppliers.memoize(() -> TridotBlocks.lambda$waxedCopper$2((java.util.function.Supplier)originalWaxableMapSupplier, block, result));
    }

    private static /* synthetic */ BiMap lambda$waxedCopper$2(java.util.function.Supplier originalWaxableMapSupplier, Block block, Block result) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.putAll((Map)originalWaxableMapSupplier.get());
        builder.put((Object)block, (Object)result);
        return builder.build();
    }

    private static /* synthetic */ BiMap lambda$weatheringCopper$1(java.util.function.Supplier originalWeatheringMapDelegate, Block block, Block result) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        builder.putAll((Map)originalWeatheringMapDelegate.get());
        builder.put((Object)block, (Object)result);
        return builder.build();
    }
}

