/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.util.struct.data.tree;

import java.util.LinkedList;
import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.data.tree.ITree;
import pro.komaru.tridot.util.struct.data.tree.NamedContTree;
import pro.komaru.tridot.util.struct.func.Boolf;

public class ContainerTree<A>
implements ITree<A> {
    private final Seq<A> children = Seq.with();
    private final Seq<ContainerTree<A>> containers = Seq.with();
    public ContainerTree<A> parent = null;

    @SafeVarargs
    public final ContainerTree<A> add(A ... all) {
        this.children.add(all);
        return this;
    }

    public ContainerTree<A> add(A child) {
        this.children.add(child);
        return this;
    }

    public ContainerTree<A> add(ContainerTree<A> child) {
        this.containers.add(child);
        child.parent = this;
        return this;
    }

    @SafeVarargs
    public final ContainerTree<A> addUnique(A ... all) {
        for (A a : all) {
            this.addUnique(a);
        }
        return this;
    }

    public ContainerTree<A> addUnique(A child) {
        this.children.addUnique(child);
        return this;
    }

    @Override
    public A child(Boolf<A> filter) {
        return this.children().find(filter);
    }

    @Override
    public A childDeep(Boolf<A> filter, boolean depthSearch) {
        A child;
        block4: {
            block3: {
                child = this.children().find(filter);
                if (!depthSearch) break block3;
                if (child != null) break block4;
                for (ITree iTree : this.containers) {
                    A other = iTree.childDeep(filter);
                    if (other == null) continue;
                    return other;
                }
                break block4;
            }
            LinkedList<ContainerTree<A>> queue = new LinkedList<ContainerTree<A>>();
            queue.add(this);
            while (!queue.isEmpty()) {
                ContainerTree containerTree = (ContainerTree)queue.poll();
                A other = containerTree.children().find(filter);
                if (other != null) {
                    return other;
                }
                queue.addAll(containerTree.containers.list());
            }
        }
        return child;
    }

    @Override
    public A childDeep(Boolf<A> filter) {
        return this.childDeep(filter, false);
    }

    @Override
    public void clean() {
        this.children().clear();
        this.containers.each(e -> {
            e.parent = null;
        });
        this.containers().clear();
    }

    @Override
    public Seq<A> children() {
        return this.children;
    }

    @Override
    public Seq<A> childrenDeep() {
        Seq all = Seq.with();
        all.addAll(this.children());
        for (ITree iTree : this.containers()) {
            all.addAll(iTree.childrenDeep());
        }
        return all;
    }

    public Seq<ContainerTree<A>> containers() {
        return this.containers;
    }

    public Seq<ContainerTree<A>> containersDeep() {
        Seq<ContainerTree<A>> all = Seq.with();
        all.addAll(this.containers());
        for (ContainerTree<A> other : this.containers()) {
            all.addAll(other.containers);
        }
        return all;
    }

    public String toString() {
        Seq<String> lines;
        String string;
        ContainerTree containerTree = this;
        if (containerTree instanceof NamedContTree) {
            NamedContTree a = (NamedContTree)containerTree;
            string = a.name;
        } else {
            string = "***";
        }
        String name = string;
        StringBuilder sb = new StringBuilder("\u001b[33m[" + name + "]\u001b[0m");
        sb.append("\n");
        for (ContainerTree containerTree2 : this.containers) {
            lines = Seq.with(containerTree2.toString().lines().map(e -> "  " + e).toList());
            if (!lines.isEmpty()) {
                lines.set(0, lines.get(0).replaceFirst(" ", ""));
            }
            sb.append("\u001b[33m-\u001b[0m");
            sb.append(String.join((CharSequence)"\n", lines));
            sb.append("\n");
        }
        for (A a : this.children) {
            lines = Seq.with(a.toString().lines().map(e -> "  " + e).toList());
            if (!lines.isEmpty()) {
                lines.set(0, lines.get(0).replaceFirst(" ", ""));
            }
            sb.append("\u001b[37m*\u001b[0m");
            sb.append(String.join((CharSequence)"\n", lines));
            sb.append("\n");
        }
        return sb.toString();
    }
}

