/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.AbstractCommandBlockActor;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.WorldEditText;
import com.sk89q.worldedit.util.formatting.text.serializer.gson.GsonComponentSerializer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;

public class ForgeBlockCommandSender
extends AbstractCommandBlockActor {
    private final BaseCommandBlock sender;
    private final UUID uuid;

    public ForgeBlockCommandSender(BaseCommandBlock sender) {
        super(new Location(ForgeAdapter.adapt(((BaseCommandBlock)Preconditions.checkNotNull((Object)sender)).m_5991_()), ForgeAdapter.adapt(sender.m_6607_())));
        this.sender = sender;
        this.uuid = UUID.nameUUIDFromBytes(("CMD" + sender.m_45439_()).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getName() {
        return this.sender.m_45439_().getString();
    }

    @Override
    @Deprecated
    public void printRaw(String msg) {
        for (String part : msg.split("\n")) {
            this.sendMessage((Component)Component.m_237113_((String)part));
        }
    }

    @Override
    @Deprecated
    public void printDebug(String msg) {
        this.sendColorized(msg, ChatFormatting.GRAY);
    }

    @Override
    @Deprecated
    public void print(String msg) {
        this.sendColorized(msg, ChatFormatting.LIGHT_PURPLE);
    }

    @Override
    @Deprecated
    public void printError(String msg) {
        this.sendColorized(msg, ChatFormatting.RED);
    }

    @Override
    public void print(com.sk89q.worldedit.util.formatting.text.Component component) {
        this.sendMessage((Component)Component.Serializer.m_130701_((String)GsonComponentSerializer.INSTANCE.serialize(WorldEditText.format(component, this.getLocale()))));
    }

    private void sendColorized(String msg, ChatFormatting formatting) {
        for (String part : msg.split("\n")) {
            MutableComponent component = Component.m_237113_((String)part);
            component.m_130940_(formatting);
            this.sendMessage((Component)component);
        }
    }

    private void sendMessage(Component textComponent) {
        this.sender.m_213846_(textComponent);
    }

    @Override
    public Locale getLocale() {
        return WorldEdit.getInstance().getConfiguration().defaultLocale;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public String[] getGroups() {
        return new String[0];
    }

    @Override
    public void checkPermission(String permission) throws AuthorizationException {
        if (!this.hasPermission(permission)) {
            throw new AuthorizationException();
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        return true;
    }

    public BaseCommandBlock getSender() {
        return this.sender;
    }

    @Override
    public SessionKey getSessionKey() {
        return new SessionKey(){
            private volatile boolean active = true;

            private void updateActive() {
                BlockPos pos = new BlockPos((int)ForgeBlockCommandSender.this.sender.m_6607_().f_82479_, (int)ForgeBlockCommandSender.this.sender.m_6607_().f_82480_, (int)ForgeBlockCommandSender.this.sender.m_6607_().f_82481_);
                int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
                int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
                if (!ForgeBlockCommandSender.this.sender.m_5991_().m_7726_().m_5563_(chunkX, chunkZ)) {
                    this.active = false;
                    return;
                }
                Block type = ForgeBlockCommandSender.this.sender.m_5991_().m_8055_(pos).m_60734_();
                this.active = type == Blocks.f_50272_ || type == Blocks.f_50448_ || type == Blocks.f_50447_;
            }

            @Override
            public String getName() {
                return ForgeBlockCommandSender.this.sender.m_45439_().getString();
            }

            @Override
            public boolean isActive() {
                ((BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER)).m_18689_(this::updateActive);
                return this.active;
            }

            @Override
            public boolean isPersistent() {
                return true;
            }

            @Override
            public UUID getUniqueId() {
                return ForgeBlockCommandSender.this.uuid;
            }
        };
    }
}

