/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.forge.net.handler;

import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.forge.ForgeAdapter;
import com.sk89q.worldedit.forge.ForgePlayer;
import com.sk89q.worldedit.forge.ForgeWorldEdit;
import com.sk89q.worldedit.forge.net.handler.PacketHandlerUtil;
import java.nio.charset.StandardCharsets;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.event.EventNetworkChannel;

public final class WECUIPacketHandler {
    private static final int PROTOCOL_VERSION = 1;
    private static final EventNetworkChannel HANDLER = PacketHandlerUtil.buildLenientHandler("cui", 1).eventNetworkChannel();

    private WECUIPacketHandler() {
    }

    public static void init() {
        HANDLER.addListener(WECUIPacketHandler::onPacketData);
    }

    public static void onPacketData(NetworkEvent.ClientCustomPayloadEvent event) {
        ServerPlayer player = ((NetworkEvent.Context)event.getSource().get()).getSender();
        LocalSession session = ForgeWorldEdit.inst.getSession(player);
        String text = event.getPayload().toString(StandardCharsets.UTF_8);
        ForgePlayer actor = ForgeAdapter.adaptPlayer(player);
        session.handleCUIInitializationMessage(text, actor);
    }
}

