/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.facade.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.NBTTools;
import mcjty.lib.varia.Tools;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.blocks.FacadeBlock;
import mcjty.xnet.modules.facade.blocks.FacadeTileEntity;
import mcjty.xnet.modules.facade.blocks.ReplaceBlockItemUseContext;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;

public class FacadeBlockItem
extends BlockItem
implements ITooltipSettings {
    private Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> !FacadeBlockItem.isMimicking(stack)), TooltipBuilder.parameter((String)"info", FacadeBlockItem::isMimicking, FacadeBlockItem::getMimickingString)});

    private static boolean isMimicking(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("mimic");
    }

    private static String getMimickingString(ItemStack stack) {
        CompoundTag mimic;
        Block value;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (value = Tools.getBlock((ResourceLocation)new ResourceLocation((mimic = tag.m_128469_("mimic")).m_128461_("Name")))) != null) {
            ItemStack s = new ItemStack((ItemLike)value, 1);
            s.m_41720_();
            return s.m_41786_().getString();
        }
        return "<unset>";
    }

    public FacadeBlockItem(FacadeBlock block) {
        super((Block)block, XNet.setup.defaultProperties());
    }

    private static void userSetMimicBlock(@Nonnull ItemStack item, BlockState mimicBlock, UseOnContext context) {
        if (mimicBlock.m_60795_()) {
            return;
        }
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        FacadeBlockItem.setMimicBlock(item, mimicBlock);
        if (world.f_46443_) {
            player.m_5661_((Component)ComponentFactory.literal((String)I18nConstants.FACADE_CURRENT_MIMIC_FORMATTED.i18n(mimicBlock.m_60734_().m_7705_())), false);
        }
    }

    public static void setMimicBlock(@Nonnull ItemStack item, BlockState mimicBlock) {
        CompoundTag tagCompound = new CompoundTag();
        CompoundTag nbt = NbtUtils.m_129202_((BlockState)mimicBlock);
        tagCompound.m_128365_("mimic", (Tag)nbt);
        item.m_41751_(tagCompound);
    }

    public static BlockState getMimicBlock(Level level, @Nonnull ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("mimic")) {
            return Blocks.f_50652_.m_49966_();
        }
        return NBTTools.readBlockState((Level)level, (CompoundTag)tagCompound.m_128469_("mimic"));
    }

    protected boolean m_40610_(@Nonnull BlockPlaceContext context, @Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        ItemStack itemstack = context.m_43722_();
        if (!itemstack.m_41619_()) {
            if (block == CableModule.NETCABLE.get()) {
                ReplaceBlockItemUseContext blockContext = new ReplaceBlockItemUseContext(context);
                FacadeBlock facadeBlock = (FacadeBlock)this.m_40614_();
                BlockState placementState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)facadeBlock.m_5573_(blockContext).m_61124_(GenericCableBlock.COLOR, (Comparable)((Object)((CableColor)((Object)state.m_61143_(GenericCableBlock.COLOR)))))).m_61124_(GenericCableBlock.NORTH, (Comparable)((Object)((ConnectorType)((Object)state.m_61143_(GenericCableBlock.NORTH)))))).m_61124_(GenericCableBlock.SOUTH, (Comparable)((Object)((ConnectorType)((Object)state.m_61143_(GenericCableBlock.SOUTH)))))).m_61124_(GenericCableBlock.WEST, (Comparable)((Object)((ConnectorType)((Object)state.m_61143_(GenericCableBlock.WEST)))))).m_61124_(GenericCableBlock.EAST, (Comparable)((Object)((ConnectorType)((Object)state.m_61143_(GenericCableBlock.EAST)))))).m_61124_(GenericCableBlock.UP, (Comparable)((Object)((ConnectorType)((Object)state.m_61143_(GenericCableBlock.UP)))))).m_61124_(GenericCableBlock.DOWN, (Comparable)((Object)((ConnectorType)((Object)state.m_61143_(GenericCableBlock.DOWN)))));
                if (this.m_7429_(blockContext, placementState)) {
                    SoundType soundtype = world.m_8055_(pos).m_60734_().getSoundType(world.m_8055_(pos), (LevelReader)world, pos, (Entity)player);
                    world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    BlockEntity te = world.m_7702_(pos);
                    if (te instanceof FacadeTileEntity) {
                        ((FacadeTileEntity)te).setMimicBlock(FacadeBlockItem.getMimicBlock(world, itemstack));
                    }
                    int amount = -1;
                    itemstack.m_41769_(amount);
                }
            } else if (block == CableModule.CONNECTOR.get() || block == CableModule.ADVANCED_CONNECTOR.get()) {
                BlockEntity te = world.m_7702_(pos);
                if (te instanceof ConnectorTileEntity) {
                    ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)te;
                    if (connectorTileEntity.getMimicBlock() == null) {
                        connectorTileEntity.setMimicBlock(FacadeBlockItem.getMimicBlock(world, itemstack));
                        SoundType soundtype = world.m_8055_(pos).m_60734_().getSoundType(world.m_8055_(pos), (LevelReader)world, pos, (Entity)player);
                        world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                        int amount = -1;
                        itemstack.m_41769_(amount);
                    } else {
                        FacadeBlockItem.userSetMimicBlock(itemstack, connectorTileEntity.getMimicBlock(), context);
                    }
                }
            } else if (block == FacadeModule.FACADE.get()) {
                BlockEntity te = world.m_7702_(pos);
                if (!(te instanceof IFacadeSupport)) {
                    return InteractionResult.FAIL;
                }
                IFacadeSupport facade = (IFacadeSupport)te;
                if (facade.getMimicBlock() == null) {
                    return InteractionResult.FAIL;
                }
                FacadeBlockItem.userSetMimicBlock(itemstack, facade.getMimicBlock(), context);
            } else {
                FacadeBlockItem.userSetMimicBlock(itemstack, state, context);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(Tools.getId((Item)this), stack, tooltip, flag);
    }
}

