/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import pro.gravit.launcher.core.LauncherNetworkAPI;

public class ClientPermissions {
    public static final ClientPermissions DEFAULT = new ClientPermissions();
    @LauncherNetworkAPI
    private List<String> roles;
    @LauncherNetworkAPI
    private List<String> perms;
    private transient List<PermissionPattern> available;

    public ClientPermissions() {
    }

    public ClientPermissions(List<String> list, List<String> list2) {
        this.roles = new ArrayList<String>(list);
        this.perms = new ArrayList<String>(list2);
    }

    public static ClientPermissions getSuperuserAccount() {
        ClientPermissions clientPermissions = new ClientPermissions();
        clientPermissions.addPerm("*");
        return clientPermissions;
    }

    public boolean hasRole(String string) {
        return this.roles != null && this.roles.contains(string);
    }

    public synchronized void compile() {
        if (this.available != null) {
            return;
        }
        if (this.perms == null) {
            this.perms = new ArrayList<String>(0);
        }
        this.available = new ArrayList<PermissionPattern>(this.perms.size());
        for (String string : this.perms) {
            this.available.add(new PermissionPattern(string));
        }
    }

    public boolean hasPerm(String string) {
        if (this.available == null) {
            this.compile();
        }
        for (PermissionPattern permissionPattern : this.available) {
            if (!permissionPattern.match(string)) continue;
            return true;
        }
        return false;
    }

    public void addRole(String string) {
        if (this.roles == null) {
            this.roles = new ArrayList<String>(1);
        }
        this.roles.add(string);
    }

    public void addPerm(String string) {
        if (this.perms == null) {
            this.perms = new ArrayList<String>(1);
        }
        this.perms.add(string);
        if (this.available == null) {
            this.available = new ArrayList<PermissionPattern>(1);
        }
        this.available.add(new PermissionPattern(string));
    }

    public void removePerm(String string) {
        if (this.perms == null) {
            return;
        }
        if (this.available == null) {
            return;
        }
        this.perms.remove(string);
        this.available.remove(new PermissionPattern(string));
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getPerms() {
        return this.perms;
    }

    public String toString() {
        return "ClientPermissions{roles=" + String.join((CharSequence)", ", this.roles == null ? Collections.emptyList() : this.roles) + ", actions=" + String.join((CharSequence)", ", this.perms == null ? Collections.emptyList() : this.perms) + "}";
    }

    public static class PermissionPattern {
        private final String[] parts;
        private final int priority;

        public PermissionPattern(String string) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            while ((n = string.indexOf("*", n2)) >= 0) {
                arrayList.add(string.substring(n2, n));
                n2 = n + 1;
            }
            arrayList.add(string.substring(n2));
            this.priority = arrayList.size() - 1;
            this.parts = arrayList.toArray(new String[0]);
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean match(String string) {
            if (this.parts.length == 0) {
                return true;
            }
            if (this.parts.length == 1) {
                return this.parts[0].equals(string);
            }
            int n = 0;
            if (!string.startsWith(this.parts[0])) {
                return false;
            }
            if (!string.endsWith(this.parts[this.parts.length - 1])) {
                return false;
            }
            for (int i = 1; i < this.parts.length - 1; ++i) {
                int n2 = string.indexOf(this.parts[i], n);
                if (n2 < 0) {
                    return false;
                }
                n = n2 + 1;
            }
            return true;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PermissionPattern permissionPattern = (PermissionPattern)object;
            return this.priority == permissionPattern.priority && Arrays.equals(this.parts, permissionPattern.parts);
        }

        public int hashCode() {
            int n = Objects.hash(this.priority);
            n = 31 * n + Arrays.hashCode(this.parts);
            return n;
        }
    }
}

