/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Flow;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import pro.gravit.launcher.core.CertificatePinningTrustManager;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class Downloader {
    private static boolean isCertificatePinning = false;
    private static boolean isNoHttp2;
    private static volatile SSLSocketFactory sslSocketFactory;
    private static volatile SSLContext sslContext;
    protected final HttpClient client;
    protected final ExecutorService executor;
    protected final Queue<DownloadTask> tasks = new ConcurrentLinkedDeque<DownloadTask>();
    protected CompletableFuture<Void> future;

    protected Downloader(HttpClient httpClient, ExecutorService executorService) {
        this.client = httpClient;
        this.executor = executorService;
    }

    public static ThreadFactory getDaemonThreadFactory(String string) {
        return runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName(string);
            thread.setDaemon(true);
            return thread;
        };
    }

    public static HttpClient.Builder newHttpClientBuilder() {
        try {
            if (isCertificatePinning) {
                return HttpClient.newBuilder().sslContext(Downloader.makeSSLContext()).version(isNoHttp2 ? HttpClient.Version.HTTP_1_1 : HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL);
            }
            return HttpClient.newBuilder().version(isNoHttp2 ? HttpClient.Version.HTTP_1_1 : HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SSLSocketFactory makeSSLSocketFactory() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, KeyManagementException {
        if (sslSocketFactory != null) {
            return sslSocketFactory;
        }
        SSLContext sSLContext = Downloader.makeSSLContext();
        sslSocketFactory = sSLContext.getSocketFactory();
        return sslSocketFactory;
    }

    public static SSLContext makeSSLContext() throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, KeyManagementException {
        if (sslContext != null) {
            return sslContext;
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(null, CertificatePinningTrustManager.getTrustManager().getTrustManagers(), new SecureRandom());
        return sSLContext;
    }

    public static Downloader downloadFile(URI uRI, Path path, ExecutorService executorService) {
        boolean bl = false;
        if (executorService == null) {
            executorService = Executors.newSingleThreadExecutor(Downloader.getDaemonThreadFactory("Downloader"));
            bl = true;
        }
        Downloader downloader = Downloader.newDownloader(executorService);
        downloader.future = downloader.downloadFile(uRI, path);
        if (bl) {
            ExecutorService executorService2 = executorService;
            downloader.future = ((CompletableFuture)downloader.future.thenAccept(void_ -> executorService2.shutdownNow())).exceptionallyCompose(throwable -> {
                executorService2.shutdownNow();
                return CompletableFuture.failedFuture(throwable);
            });
        }
        return downloader;
    }

    public static Downloader downloadList(List<SizedFile> list, String string, Path path, DownloadCallback downloadCallback, ExecutorService executorService, int n) throws Exception {
        boolean bl = false;
        LogHelper.info("Download with Java 11+ HttpClient");
        if (executorService == null) {
            executorService = Executors.newWorkStealingPool(Math.min(3, n));
            bl = true;
        }
        Downloader downloader = Downloader.newDownloader(executorService);
        downloader.future = downloader.downloadFiles(list, string, path, downloadCallback, executorService, n);
        if (bl) {
            ExecutorService executorService2 = executorService;
            downloader.future = ((CompletableFuture)downloader.future.thenAccept(void_ -> executorService2.shutdownNow())).exceptionallyCompose(throwable -> {
                executorService2.shutdownNow();
                return CompletableFuture.failedFuture(throwable);
            });
        }
        return downloader;
    }

    public static Downloader newDownloader(ExecutorService executorService) {
        if (executorService == null) {
            throw new NullPointerException();
        }
        HttpClient.Builder builder = Downloader.newHttpClientBuilder().executor(executorService);
        HttpClient httpClient = builder.build();
        return new Downloader(httpClient, executorService);
    }

    public void cancel() {
        for (DownloadTask downloadTask : this.tasks) {
            if (downloadTask.isCompleted()) continue;
            downloadTask.cancel();
        }
        this.tasks.clear();
    }

    public boolean isCanceled() {
        return this.executor.isTerminated();
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    public CompletableFuture<Void> downloadFile(URI uRI, Path path) {
        try {
            IOHelper.createParentDirs(path);
        }
        catch (IOException iOException) {
            return CompletableFuture.failedFuture(iOException);
        }
        return this.client.sendAsync(HttpRequest.newBuilder().GET().uri(uRI).build(), HttpResponse.BodyHandlers.ofFile(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING)).thenCompose(httpResponse -> {
            if (httpResponse.statusCode() < 200 || httpResponse.statusCode() >= 400) {
                return CompletableFuture.failedFuture(new IOException(String.format("Failed to download %s: code %d", uRI.toString(), httpResponse.statusCode())));
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<Void> downloadFile(String string, Path path, DownloadCallback downloadCallback, ExecutorService executorService) throws Exception {
        return this.downloadFiles(new ArrayList<SizedFile>(List.of(new SizedFile(string, path.getFileName().toString()))), null, path.getParent(), downloadCallback, executorService, 1);
    }

    public CompletableFuture<Void> downloadFile(String string, Path path, long l, DownloadCallback downloadCallback, ExecutorService executorService) throws Exception {
        return this.downloadFiles(new ArrayList<SizedFile>(List.of(new SizedFile(string, path.getFileName().toString(), l))), null, path.getParent(), downloadCallback, executorService, 1);
    }

    public CompletableFuture<Void> downloadFiles(List<SizedFile> list, String string, Path path, DownloadCallback downloadCallback, ExecutorService executorService, int n) throws Exception {
        URI uRI = string == null ? null : new URI(string);
        Collections.shuffle(list);
        ConcurrentLinkedDeque<SizedFile> concurrentLinkedDeque = new ConcurrentLinkedDeque<SizedFile>(list);
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        AtomicInteger atomicInteger = new AtomicInteger(n);
        ConsumerObject consumerObject = new ConsumerObject();
        Consumer<HttpResponse> consumer = httpResponse2 -> {
            SizedFile sizedFile;
            if (downloadCallback != null && httpResponse2 != null) {
                downloadCallback.onComplete((Path)httpResponse2.body());
            }
            if ((sizedFile = (SizedFile)concurrentLinkedDeque.poll()) == null) {
                if (atomicInteger.decrementAndGet() == 0) {
                    completableFuture.complete(null);
                }
                return;
            }
            try {
                DownloadTask downloadTask = this.sendAsync(sizedFile, uRI, path, downloadCallback);
                ((CompletableFuture)((CompletableFuture)downloadTask.completableFuture.thenCompose(httpResponse -> {
                    if (httpResponse.statusCode() < 200 || httpResponse.statusCode() >= 300) {
                        return CompletableFuture.failedFuture(new IOException(String.format("Failed to download %s: code %d", sizedFile.urlPath != null ? sizedFile.urlPath : sizedFile.filePath, httpResponse.statusCode())));
                    }
                    return CompletableFuture.completedFuture(httpResponse);
                })).thenAccept(consumerObject.next)).exceptionally(throwable -> {
                    completableFuture.completeExceptionally((Throwable)throwable);
                    return null;
                });
            }
            catch (Exception exception) {
                LogHelper.error(exception);
                completableFuture.completeExceptionally(exception);
            }
        };
        consumerObject.next = consumer;
        for (int i = 0; i < n; ++i) {
            consumer.accept(null);
        }
        return completableFuture;
    }

    protected DownloadTask sendAsync(SizedFile sizedFile, URI uRI, Path path, DownloadCallback downloadCallback) throws Exception {
        IOHelper.createParentDirs(path.resolve(sizedFile.filePath));
        ProgressTrackingBodyHandler<Path> progressTrackingBodyHandler = this.makeBodyHandler(path.resolve(sizedFile.filePath), downloadCallback);
        CompletableFuture<HttpResponse<Path>> completableFuture = this.client.sendAsync(this.makeHttpRequest(uRI, sizedFile.urlPath), progressTrackingBodyHandler);
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        atomicReference.set(new DownloadTask(progressTrackingBodyHandler, null));
        this.tasks.add(atomicReference.get());
        ((DownloadTask)atomicReference.get()).completableFuture = completableFuture.thenApply(httpResponse -> {
            this.tasks.remove(atomicReference.get());
            return httpResponse;
        });
        return atomicReference.get();
    }

    protected HttpRequest makeHttpRequest(URI uRI, String string) throws URISyntaxException {
        URI uRI2;
        if (uRI != null) {
            String string2 = uRI.getScheme();
            Object object = uRI.getHost();
            int n = uRI.getPort();
            if (n != -1) {
                object = (String)object + ":" + n;
            }
            String string3 = uRI.getPath();
            uRI2 = new URI(string2, (String)object, string3 + string, "", "");
        } else {
            uRI2 = new URI(string);
        }
        return HttpRequest.newBuilder().GET().uri(uRI2).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36").build();
    }

    protected ProgressTrackingBodyHandler<Path> makeBodyHandler(Path path, DownloadCallback downloadCallback) {
        return new ProgressTrackingBodyHandler<Path>(HttpResponse.BodyHandlers.ofFile(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING), downloadCallback);
    }

    public static interface DownloadCallback {
        public void apply(long var1);

        public void onComplete(Path var1);
    }

    public static class DownloadTask {
        public final ProgressTrackingBodyHandler<Path> bodyHandler;
        public CompletableFuture<HttpResponse<Path>> completableFuture;

        public DownloadTask(ProgressTrackingBodyHandler<Path> progressTrackingBodyHandler, CompletableFuture<HttpResponse<Path>> completableFuture) {
            this.bodyHandler = progressTrackingBodyHandler;
            this.completableFuture = completableFuture;
        }

        public boolean isCompleted() {
            return this.completableFuture.isDone() | this.completableFuture.isCompletedExceptionally();
        }

        public void cancel() {
            this.bodyHandler.cancel();
        }
    }

    public static class SizedFile {
        public final String urlPath;
        public final String filePath;
        public final long size;

        public SizedFile(String string, long l) {
            this.urlPath = string;
            this.filePath = string;
            this.size = l;
        }

        public SizedFile(String string, String string2, long l) {
            this.urlPath = string;
            this.filePath = string2;
            this.size = l;
        }

        public SizedFile(String string, String string2) {
            this.urlPath = string;
            this.filePath = string2;
            this.size = -1L;
        }
    }

    private static class ConsumerObject {
        Consumer<HttpResponse<Path>> next = null;

        private ConsumerObject() {
        }
    }

    public static class ProgressTrackingBodyHandler<T>
    implements HttpResponse.BodyHandler<T> {
        private final HttpResponse.BodyHandler<T> delegate;
        private final DownloadCallback callback;
        private ProgressTrackingBodySubscriber subscriber;
        private boolean isCanceled = false;

        public ProgressTrackingBodyHandler(HttpResponse.BodyHandler<T> bodyHandler, DownloadCallback downloadCallback) {
            this.delegate = bodyHandler;
            this.callback = downloadCallback;
        }

        @Override
        public HttpResponse.BodySubscriber<T> apply(HttpResponse.ResponseInfo responseInfo) {
            this.subscriber = new ProgressTrackingBodySubscriber(this.delegate.apply(responseInfo));
            if (this.isCanceled) {
                this.subscriber.cancel();
            }
            return this.subscriber;
        }

        public void cancel() {
            this.isCanceled = true;
            if (this.subscriber != null) {
                this.subscriber.cancel();
            }
        }

        private class ProgressTrackingBodySubscriber
        implements HttpResponse.BodySubscriber<T> {
            private final HttpResponse.BodySubscriber<T> delegate;
            private Flow.Subscription subscription;
            private boolean isCanceled = false;

            public ProgressTrackingBodySubscriber(HttpResponse.BodySubscriber<T> bodySubscriber) {
                this.delegate = bodySubscriber;
            }

            @Override
            public CompletionStage<T> getBody() {
                return this.delegate.getBody();
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                if (this.isCanceled) {
                    subscription.cancel();
                }
                this.delegate.onSubscribe(subscription);
            }

            @Override
            public void onNext(List<ByteBuffer> list) {
                long l = 0L;
                for (ByteBuffer byteBuffer : list) {
                    l += (long)byteBuffer.remaining();
                }
                if (ProgressTrackingBodyHandler.this.callback != null) {
                    ProgressTrackingBodyHandler.this.callback.apply(l);
                }
                this.delegate.onNext(list);
            }

            @Override
            public void onError(Throwable throwable) {
                this.delegate.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.delegate.onComplete();
            }

            public void cancel() {
                this.isCanceled = true;
                if (this.subscription != null) {
                    this.subscription.cancel();
                }
            }
        }
    }
}

