/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.LauncherModulesManager;
import pro.gravit.launcher.core.LauncherInjectionConstructor;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.launcher.core.serialize.stream.StreamObject;
import pro.gravit.launcher.gui.JavaRuntimeModule;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class LauncherConfig
extends StreamObject {
    private static final List<byte[]> secureConfigCertificates;
    private static final List<Class<?>> modulesClasses;
    private static final MethodType VOID_TYPE;
    public final String projectName;
    public final int clientPort;
    public final LauncherTrustManager trustManager;
    public final ECPublicKey ecdsaPublicKey;
    public final RSAPublicKey rsaPublicKey;
    public final Map<String, byte[]> runtime;
    public final String secureCheckHash;
    public final String secureCheckSalt;
    public final String passwordEncryptKey;
    public final String runtimeEncryptKey;
    public final String address;
    public String secretKeyClient;
    public String unlockSecret;
    public LauncherEnvironment environment;
    public long buildNumber;

    @LauncherInjectionConstructor
    public LauncherConfig(HInput hInput) throws IOException, InvalidKeySpecException {
        this.ecdsaPublicKey = SecurityHelper.toPublicECDSAKey(hInput.readByteArray(2048));
        this.rsaPublicKey = SecurityHelper.toPublicRSAKey(hInput.readByteArray(2048));
        this.secureCheckHash = "w2FtVln7JZCtZQ069GoLaJ4mBOG5fwPJSROaNTGJPnA=";
        this.secureCheckSalt = "baa2355703cd121101ca01ef5f4d2c9d";
        this.passwordEncryptKey = "001a1644158529a25f135f5067383ca3";
        this.runtimeEncryptKey = null;
        this.projectName = "KomaruTEST";
        this.clientPort = 32477;
        this.secretKeyClient = "380d0ee0fbbfd02126139ee7fcade31b";
        try {
            this.trustManager = new LauncherTrustManager(secureConfigCertificates);
        }
        catch (CertificateException certificateException) {
            throw new IOException(certificateException);
        }
        this.address = "ws://87.251.16.231:9274/api";
        this.environment = LauncherEnvironment.STD;
        Launcher.applyLauncherEnv(this.environment);
        int n = hInput.readLength(0);
        HashMap hashMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            String string = hInput.readString(255);
            VerifyHelper.putIfAbsent(hashMap, string, hInput.readByteArray(2048), String.format("Duplicate runtime resource: '%s'", string));
        }
        this.runtime = Collections.unmodifiableMap(hashMap);
        this.unlockSecret = "bf78597a9fe8d6d53936a1804e8b649c";
        this.buildNumber = 15L;
    }

    public LauncherConfig(String string, ECPublicKey eCPublicKey, RSAPublicKey rSAPublicKey, Map<String, byte[]> map, String string2) {
        this.address = string;
        this.ecdsaPublicKey = eCPublicKey;
        this.rsaPublicKey = rSAPublicKey;
        this.runtime = Map.copyOf(map);
        this.projectName = string2;
        this.clientPort = 32148;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
        this.trustManager = null;
    }

    public LauncherConfig(String string, Map<String, byte[]> map, String string2, LauncherEnvironment launcherEnvironment, LauncherTrustManager launcherTrustManager) {
        this.address = string;
        this.runtime = Map.copyOf(map);
        this.projectName = string2;
        this.clientPort = 32148;
        this.trustManager = launcherTrustManager;
        this.rsaPublicKey = null;
        this.ecdsaPublicKey = null;
        this.environment = launcherEnvironment;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
    }

    public static void initModules(LauncherModulesManager launcherModulesManager) {
        if (JVMHelper.JVM_VERSION >= 17) {
            modulesClasses.addAll(ModernModulesClass.modulesClasses);
        }
        for (Class<?> clazz : modulesClasses) {
            try {
                launcherModulesManager.loadModule((LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList()));
            }
            catch (Throwable throwable) {
                LogHelper.error(throwable);
            }
        }
        modulesClasses.clear();
    }

    @Override
    public void write(HOutput hOutput) throws IOException {
        hOutput.writeByteArray(this.ecdsaPublicKey.getEncoded(), 2048);
        hOutput.writeByteArray(this.rsaPublicKey.getEncoded(), 2048);
        Set<Map.Entry<String, byte[]>> set = this.runtime.entrySet();
        hOutput.writeLength(set.size(), 0);
        for (Map.Entry<String, byte[]> entry : this.runtime.entrySet()) {
            hOutput.writeString(entry.getKey(), 255);
            hOutput.writeByteArray(entry.getValue(), 2048);
        }
    }

    static {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(Base64.getDecoder().decode("MIIBSTCB8aADAgECAgEAMAoGCCqGSM49BAMCMDgxITAfBgNVBAMMGEtvbWFydVRFU1QgQXV0b2dlbmVyYXRlZDETMBEGA1UECgwKS29tYXJ1VEVTVDAeFw0yNjAxMDUwMDAwMDBaFw0zNjAxMDMwMDAwMDBaMA0xCzAJBgNVBAMMAmNhMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEdT1XDPWQUz4g+cJAyseD/5XfHJY0eIMvDgf2sV+QEBfuYoyAblzRBoKRwnjC8j7fTl3DFsTbK0/I9bS20Wj/IqMXMBUwEwYDVR0lBAwwCgYIKwYBBQUHAwMwCgYIKoZIzj0EAwIDRwAwRAIgCQlPiOx+otAyDh12RO3AqtTP4bp6m0HZms/L0j9UPT8CIAEy9+fzsZh8p3H4oM33qL+3oLv/CwfCiy1QyIk317Qq"));
        secureConfigCertificates = arrayList;
        modulesClasses = new ArrayList(0);
        VOID_TYPE = MethodType.methodType(Void.TYPE);
    }

    public static enum LauncherEnvironment {
        DEV,
        DEBUG,
        STD,
        PROD;

    }

    private static class ModernModulesClass {
        private static final List<Class<?>> modulesClasses;

        private ModernModulesClass() {
        }

        static {
            ArrayList arrayList = new ArrayList(1);
            arrayList.add(JavaRuntimeModule.class);
            modulesClasses = arrayList;
        }
    }
}

