/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.modules.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import pro.gravit.launcher.base.modules.LauncherInitContext;
import pro.gravit.launcher.base.modules.LauncherModule;
import pro.gravit.launcher.base.modules.LauncherModuleInfo;
import pro.gravit.launcher.base.modules.LauncherModulesManager;
import pro.gravit.launcher.base.modules.ModulesConfigManager;
import pro.gravit.launcher.base.modules.impl.SimpleModuleContext;
import pro.gravit.launcher.base.modules.impl.SimpleModulesConfigManager;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SimpleModuleManager
implements LauncherModulesManager {
    private static final MethodType VOID_TYPE = MethodType.methodType(Void.TYPE);
    protected final List<LauncherModule> modules = new ArrayList<LauncherModule>();
    protected final List<String> moduleNames = new ArrayList<String>();
    protected final SimpleModuleContext context;
    protected final ModulesConfigManager modulesConfigManager;
    protected final Path modulesDir;
    protected final LauncherTrustManager trustManager;
    protected final ModulesClassLoader classLoader = this.createClassLoader();
    protected LauncherInitContext initContext;

    protected ModulesClassLoader createClassLoader() {
        return new ModulesClassLoader(new URL[0], SimpleModuleManager.class.getClassLoader());
    }

    public SimpleModuleManager(Path path, Path path2) {
        this.modulesConfigManager = new SimpleModulesConfigManager(path2);
        this.context = new SimpleModuleContext(this, this.modulesConfigManager);
        this.modulesDir = path;
        this.trustManager = null;
    }

    public SimpleModuleManager(Path path, Path path2, LauncherTrustManager launcherTrustManager) {
        this.modulesConfigManager = new SimpleModulesConfigManager(path2);
        this.context = new SimpleModuleContext(this, this.modulesConfigManager);
        this.modulesDir = path;
        this.trustManager = launcherTrustManager;
    }

    private static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] objectArray = clazz.getSigners();
        if (objectArray == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(objectArray).filter(object -> object instanceof X509Certificate).map(object -> (X509Certificate)object).toArray(X509Certificate[]::new);
    }

    public void autoload() throws IOException {
        this.autoload(this.modulesDir);
    }

    public void autoload(Path path) throws IOException {
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        } else {
            IOHelper.walk(path, new ModulesVisitor(), true);
        }
    }

    public void initModules(LauncherInitContext launcherInitContext) {
        boolean bl = true;
        this.modules.sort((launcherModule, launcherModule2) -> {
            int n = launcherModule.getModuleInfo().priority;
            int n2 = launcherModule2.getModuleInfo().priority;
            return Integer.compare(n, n2);
        });
        while (bl) {
            bl = false;
            for (LauncherModule launcherModule3 : this.modules) {
                if (!launcherModule3.getInitStatus().equals((Object)LauncherModule.InitStatus.INIT_WAIT) || !this.checkDepend(launcherModule3)) continue;
                bl = true;
                launcherModule3.setInitStatus(LauncherModule.InitStatus.INIT);
                launcherModule3.init(launcherInitContext);
                launcherModule3.setInitStatus(LauncherModule.InitStatus.FINISH);
            }
        }
        for (LauncherModule launcherModule3 : this.modules) {
            LauncherModuleInfo launcherModuleInfo;
            if (launcherModule3.getInitStatus().equals((Object)LauncherModule.InitStatus.INIT_WAIT)) {
                launcherModuleInfo = launcherModule3.getModuleInfo();
                LogHelper.warning("Module %s required %s. Cyclic dependencies?", launcherModuleInfo.name, Arrays.toString(launcherModuleInfo.dependencies));
                launcherModule3.setInitStatus(LauncherModule.InitStatus.INIT);
                launcherModule3.init(launcherInitContext);
                launcherModule3.setInitStatus(LauncherModule.InitStatus.FINISH);
                continue;
            }
            if (!launcherModule3.getInitStatus().equals((Object)LauncherModule.InitStatus.PRE_INIT_WAIT)) continue;
            launcherModuleInfo = launcherModule3.getModuleInfo();
            LogHelper.error("Module %s skip pre-init phase. This module NOT finish loading", launcherModuleInfo.name, Arrays.toString(launcherModuleInfo.dependencies));
        }
    }

    private boolean checkDepend(LauncherModule launcherModule) {
        LauncherModuleInfo launcherModuleInfo = launcherModule.getModuleInfo();
        for (String string : launcherModuleInfo.dependencies) {
            LauncherModule launcherModule2 = this.getModule(string);
            if (launcherModule2 == null) {
                throw new RuntimeException(String.format("Module %s required %s. %s not found", launcherModuleInfo.name, string, string));
            }
            if (launcherModule2.getInitStatus().equals((Object)LauncherModule.InitStatus.FINISH)) continue;
            return false;
        }
        return true;
    }

    @Override
    public LauncherModule loadModule(LauncherModule launcherModule) {
        Object object;
        if (this.modules.contains(launcherModule)) {
            return launcherModule;
        }
        if (launcherModule.getCheckStatus() == null) {
            object = this.checkModuleClass(launcherModule.getClass());
            this.verifyClassCheckResult((LauncherTrustManager.CheckClassResult)object);
            launcherModule.setCheckResult((LauncherTrustManager.CheckClassResult)object);
        }
        this.modules.add(launcherModule);
        object = launcherModule.getModuleInfo();
        this.moduleNames.add(((LauncherModuleInfo)object).name);
        launcherModule.setContext(this.context);
        launcherModule.preInit();
        if (this.initContext != null) {
            launcherModule.setInitStatus(LauncherModule.InitStatus.INIT);
            launcherModule.init(this.initContext);
            launcherModule.setInitStatus(LauncherModule.InitStatus.FINISH);
        }
        return launcherModule;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LauncherModule loadModule(Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            LauncherModule launcherModule;
            String string;
            String string2 = string = jarFile.getManifest() != null ? jarFile.getManifest().getMainAttributes().getValue("Module-Main-Class") : null;
            if (string == null) {
                LogHelper.error("In module %s Module-Main-Class not found", path.toString());
                LauncherModule launcherModule2 = null;
                return launcherModule2;
            }
            this.classLoader.addURL(path.toUri().toURL());
            Class<?> clazz = Class.forName(string, false, this.classLoader);
            LauncherTrustManager.CheckClassResult checkClassResult = this.checkModuleClass(clazz);
            try {
                this.verifyClassCheckResultExceptional(checkClassResult);
            }
            catch (Exception exception) {
                LogHelper.error(exception);
                LogHelper.error("In module %s signature check failed", path.toString());
                LauncherModule launcherModule3 = null;
                jarFile.close();
                return launcherModule3;
            }
            if (!LauncherModule.class.isAssignableFrom(clazz)) {
                throw new ClassNotFoundException("Invalid module class... Not contains LauncherModule in hierarchy.");
            }
            try {
                launcherModule = (LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList());
                launcherModule.setCheckResult(checkClassResult);
            }
            catch (Throwable throwable) {
                throw (InstantiationException)new InstantiationException("Error on instancing...").initCause(throwable);
            }
            this.loadModule(launcherModule);
            LauncherModule launcherModule4 = launcherModule;
            return launcherModule4;
        }
        catch (ClassNotFoundException | InstantiationException reflectiveOperationException) {
            LogHelper.error(reflectiveOperationException);
            LogHelper.error("In module %s Module-Main-Class incorrect", path.toString());
            return null;
        }
    }

    public LauncherTrustManager.CheckClassResult checkModuleClass(Class<? extends LauncherModule> clazz) {
        if (this.trustManager == null) {
            return null;
        }
        X509Certificate[] x509CertificateArray = SimpleModuleManager.getCertificates(clazz);
        return this.trustManager.checkCertificates(x509CertificateArray, this.trustManager::stdCertificateChecker);
    }

    public boolean verifyClassCheckResult(LauncherTrustManager.CheckClassResult checkClassResult) {
        if (checkClassResult == null) {
            return false;
        }
        return checkClassResult.type == LauncherTrustManager.CheckClassResultType.SUCCESS;
    }

    public void verifyClassCheckResultExceptional(LauncherTrustManager.CheckClassResult checkClassResult) throws Exception {
        if (this.verifyClassCheckResult(checkClassResult)) {
            return;
        }
        if (checkClassResult.exception != null) {
            throw checkClassResult.exception;
        }
        throw new SecurityException(checkClassResult.type.name());
    }

    @Override
    public LauncherModule getModule(String string) {
        for (LauncherModule launcherModule : this.modules) {
            LauncherModuleInfo launcherModuleInfo = launcherModule.getModuleInfo();
            if (!launcherModuleInfo.name.equals(string) && (launcherModuleInfo.providers.length <= 0 || !Arrays.asList(launcherModuleInfo.providers).contains(string))) continue;
            return launcherModule;
        }
        return null;
    }

    @Override
    public LauncherModule getCoreModule() {
        return null;
    }

    @Override
    public ClassLoader getModuleClassLoader() {
        return this.classLoader;
    }

    @Override
    public <T extends LauncherModule> T getModule(Class<? extends T> clazz) {
        for (LauncherModule launcherModule : this.modules) {
            if (!clazz.isAssignableFrom(launcherModule.getClass())) continue;
            return (T)launcherModule;
        }
        return null;
    }

    @Override
    public <T> T getModuleByInterface(Class<T> clazz) {
        for (LauncherModule launcherModule : this.modules) {
            if (!clazz.isAssignableFrom(launcherModule.getClass())) continue;
            return (T)launcherModule;
        }
        return null;
    }

    @Override
    public <T> List<T> getModulesByInterface(Class<T> clazz) {
        ArrayList<LauncherModule> arrayList = new ArrayList<LauncherModule>();
        for (LauncherModule launcherModule : this.modules) {
            if (!clazz.isAssignableFrom(launcherModule.getClass())) continue;
            arrayList.add(launcherModule);
        }
        return arrayList;
    }

    @Override
    public <T extends LauncherModule> T findModule(Class<? extends T> clazz, Predicate<Version> predicate) {
        for (LauncherModule launcherModule : this.modules) {
            LauncherModuleInfo launcherModuleInfo = launcherModule.getModuleInfo();
            if (!predicate.test(launcherModuleInfo.version) || !clazz.isAssignableFrom(launcherModule.getClass())) continue;
            return (T)launcherModule;
        }
        return null;
    }

    @Override
    public LauncherModule findModule(String string, Predicate<Version> predicate) {
        for (LauncherModule launcherModule : this.modules) {
            LauncherModuleInfo launcherModuleInfo = launcherModule.getModuleInfo();
            if (!predicate.test(launcherModuleInfo.version) || !string.equals(launcherModuleInfo.name)) continue;
            return launcherModule;
        }
        return null;
    }

    @Override
    public <T extends LauncherModule.Event> void invokeEvent(T t) {
        for (LauncherModule launcherModule : this.modules) {
            launcherModule.callEvent(t);
            if (!t.isCancel()) continue;
            return;
        }
    }

    @Override
    public ModulesConfigManager getConfigManager() {
        return this.modulesConfigManager;
    }

    void addUrlToClassLoader(URL uRL) {
        this.classLoader.addURL(uRL);
    }

    protected static class ModulesClassLoader
    extends URLClassLoader {
        public ModulesClassLoader(URL[] uRLArray, ClassLoader classLoader) {
            super("MODULES", uRLArray, classLoader);
        }

        @Override
        public void addURL(URL uRL) {
            super.addURL(uRL);
        }
    }

    protected final class ModulesVisitor
    extends SimpleFileVisitor<Path> {
        private ModulesVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
            if (path.toFile().getName().endsWith(".jar")) {
                SimpleModuleManager.this.loadModule(path);
            }
            return super.visitFile(path, basicFileAttributes);
        }
    }
}

