/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.modules.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import pro.gravit.launcher.base.config.SimpleConfigurable;
import pro.gravit.launcher.base.modules.ModulesConfigManager;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class SimpleModulesConfigManager
implements ModulesConfigManager {
    public final Path configDir;

    public SimpleModulesConfigManager(Path path) {
        this.configDir = path;
    }

    @Override
    public Path getModuleConfig(String string) {
        return this.getModuleConfig(string, "Config");
    }

    @Override
    public Path getModuleConfig(String string, String string2) {
        return this.getModuleConfigDir(string).resolve(string2.concat(".json"));
    }

    @Override
    public Path getModuleConfigDir(String string) {
        if (!IOHelper.isDir(this.configDir)) {
            try {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        }
        return this.configDir.resolve(string);
    }

    @Override
    public <T> SimpleConfigurable<T> getConfigurable(Class<T> clazz, Path path) {
        return new SimpleConfigurable<T>(clazz, path);
    }
}

