/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.ExitRequestEvent;
import pro.gravit.launcher.base.events.request.FeaturesRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.base.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.base.events.request.LauncherRequestEvent;
import pro.gravit.launcher.base.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.base.events.request.ProfileByUsernameRequestEvent;
import pro.gravit.launcher.base.events.request.SecurityReportRequestEvent;
import pro.gravit.launcher.base.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.base.modules.LauncherModulesManager;
import pro.gravit.launcher.base.modules.events.OfflineModeEvent;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.CheckServerRequest;
import pro.gravit.launcher.base.request.auth.ExitRequest;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.base.request.auth.JoinServerRequest;
import pro.gravit.launcher.base.request.auth.SetProfileRequest;
import pro.gravit.launcher.base.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.base.request.management.FeaturesRequest;
import pro.gravit.launcher.base.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.base.request.secure.SecurityReportRequest;
import pro.gravit.launcher.base.request.update.LauncherRequest;
import pro.gravit.launcher.base.request.uuid.ProfileByUUIDRequest;
import pro.gravit.launcher.base.request.uuid.ProfileByUsernameRequest;
import pro.gravit.launcher.base.request.websockets.OfflineRequestService;
import pro.gravit.launcher.client.ClientGsonManager;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.ClientParams;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.utils.NativeJVMHalt;
import pro.gravit.launcher.core.LauncherTrustManager;
import pro.gravit.utils.helper.JVMHelper;

public class ClientLauncherMethods {
    public static void verifyNoAgent() {
        if (JVMHelper.RUNTIME_MXBEAN.getInputArguments().stream().filter(string -> string != null && !string.isEmpty()).anyMatch(string -> string.contains("javaagent"))) {
            throw new SecurityException("JavaAgent found");
        }
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] objectArray = clazz.getSigners();
        if (objectArray == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(objectArray).filter(object -> object instanceof X509Certificate).map(object -> (X509Certificate)object).toArray(X509Certificate[]::new);
    }

    public static void beforeExit(int n) {
        try {
            ClientLauncherEntryPoint.modulesManager.invokeEvent(new ClientExitPhase(n));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void forceExit(int n) {
        try {
            System.exit(n);
        }
        catch (Throwable throwable) {
            NativeJVMHalt.haltA(n);
        }
    }

    public static void exitLauncher(int n) {
        ClientLauncherMethods.beforeExit(n);
        ClientLauncherMethods.forceExit(n);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager launcherTrustManager = Launcher.getConfig().trustManager;
        if (launcherTrustManager == null) {
            return;
        }
        X509Certificate[] x509CertificateArray = ClientLauncherMethods.getCertificates(clazz);
        if (x509CertificateArray == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            launcherTrustManager.checkCertificatesSuccess(x509CertificateArray, launcherTrustManager::stdCertificateChecker);
        }
        catch (Exception exception) {
            throw new SecurityException(exception);
        }
    }

    public static void initGson(ClientModuleManager clientModuleManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new ClientGsonManager(clientModuleManager);
        Launcher.gsonManager.initGson();
    }

    public static RequestService initOffline(LauncherModulesManager launcherModulesManager, ClientParams clientParams) {
        OfflineRequestService offlineRequestService = new OfflineRequestService();
        ClientLauncherMethods.applyBasicOfflineProcessors(offlineRequestService);
        ClientLauncherMethods.applyClientOfflineProcessors(offlineRequestService, clientParams);
        OfflineModeEvent offlineModeEvent = new OfflineModeEvent(offlineRequestService);
        launcherModulesManager.invokeEvent(offlineModeEvent);
        return offlineModeEvent.service;
    }

    public static void applyClientOfflineProcessors(OfflineRequestService offlineRequestService, ClientParams clientParams) {
        offlineRequestService.registerRequestProcessor(ProfileByUsernameRequest.class, profileByUsernameRequest -> {
            if (clientParams.playerProfile.username.equals(profileByUsernameRequest.username)) {
                return new ProfileByUsernameRequestEvent(clientParams.playerProfile);
            }
            throw new RequestException("User not found");
        });
        offlineRequestService.registerRequestProcessor(ProfileByUUIDRequest.class, profileByUUIDRequest -> {
            if (clientParams.playerProfile.uuid.equals(profileByUUIDRequest.uuid)) {
                return new ProfileByUUIDRequestEvent(clientParams.playerProfile);
            }
            throw new RequestException("User not found");
        });
    }

    public static void applyBasicOfflineProcessors(OfflineRequestService offlineRequestService) {
        offlineRequestService.registerRequestProcessor(LauncherRequest.class, launcherRequest -> new LauncherRequestEvent(false, (String)null));
        offlineRequestService.registerRequestProcessor(CheckServerRequest.class, checkServerRequest -> {
            throw new RequestException("CheckServer disabled in offline mode");
        });
        offlineRequestService.registerRequestProcessor(GetAvailabilityAuthRequest.class, getAvailabilityAuthRequest -> {
            ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> arrayList = new ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>();
            arrayList.add(new AuthLoginOnlyDetails());
            GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability = new GetAvailabilityAuthRequestEvent.AuthAvailability(arrayList, "offline", "Offline Mode", true, new HashSet<String>());
            ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability> arrayList2 = new ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability>(1);
            arrayList2.add(authAvailability);
            return new GetAvailabilityAuthRequestEvent(arrayList2);
        });
        offlineRequestService.registerRequestProcessor(JoinServerRequest.class, joinServerRequest -> new JoinServerRequestEvent(false));
        offlineRequestService.registerRequestProcessor(ExitRequest.class, exitRequest -> new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
        offlineRequestService.registerRequestProcessor(SetProfileRequest.class, setProfileRequest -> new SetProfileRequestEvent(null));
        offlineRequestService.registerRequestProcessor(FeaturesRequest.class, featuresRequest -> new FeaturesRequestEvent());
        offlineRequestService.registerRequestProcessor(GetSecureLevelInfoRequest.class, getSecureLevelInfoRequest -> new GetSecureLevelInfoRequestEvent(null, false));
        offlineRequestService.registerRequestProcessor(SecurityReportRequest.class, securityReportRequest -> new SecurityReportRequestEvent(SecurityReportRequestEvent.ReportAction.NONE));
    }
}

