/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.ClientProfileVersions;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.base.profiles.optional.actions.OptionalActionClientArgs;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.utils.Version;

public class ClientParams {
    public long timestamp;
    public String assetDir;
    public String clientDir;
    public String resourcePackDir;
    public String nativesDir;
    public PlayerProfile playerProfile;
    public ClientProfile profile;
    public String accessToken;
    public boolean autoEnter;
    public boolean fullScreen;
    public boolean lwjglGlfwWayland;
    public int ram;
    public int width;
    public int height;
    public Set<OptionalAction> actions = new HashSet<OptionalAction>();
    public UUID session;
    public AuthRequestEvent.OAuthRequestEvent oauth;
    public String authId;
    public long oauthExpiredTime;
    public Map<String, Request.ExtendedToken> extendedTokens;
    public boolean offlineMode;
    public transient HashedDir assetHDir;
    public transient HashedDir clientHDir;
    public transient HashedDir javaHDir;

    public void addClientArgs(Collection<String> collection) {
        if (this.profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) >= 0) {
            this.addModernClientArgs(collection);
        } else {
            this.addClientLegacyArgs(collection);
        }
    }

    public void addClientLegacyArgs(Collection<String> collection) {
        collection.add(this.playerProfile.username);
        collection.add(this.accessToken);
        Collections.addAll(collection, "--version", this.profile.getVersion().toString());
        Collections.addAll(collection, "--gameDir", this.clientDir);
        Collections.addAll(collection, "--assetsDir", this.assetDir);
    }

    private void addModernClientArgs(Collection<String> collection) {
        ClientProfile.Version version = this.profile.getVersion();
        Collections.addAll(collection, "--username", this.playerProfile.username);
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_2) >= 0) {
            Collections.addAll(collection, "--uuid", Launcher.toHash(this.playerProfile.uuid));
            Collections.addAll(collection, "--accessToken", this.accessToken);
            if (version.compareTo(ClientProfileVersions.MINECRAFT_1_7_10) >= 0) {
                Collections.addAll(collection, "--userType", "mojang");
                Collections.addAll(collection, "--userProperties", "{}");
                Collections.addAll(collection, "--assetIndex", this.profile.getAssetIndex());
            }
        } else {
            Collections.addAll(collection, "--session", this.accessToken);
        }
        Collections.addAll(collection, "--version", this.profile.getVersion().toString());
        Collections.addAll(collection, "--gameDir", this.clientDir);
        Collections.addAll(collection, "--assetsDir", this.assetDir);
        Collections.addAll(collection, "--resourcePackDir", this.resourcePackDir);
        if (version.compareTo(ClientProfileVersions.MINECRAFT_1_9_4) >= 0) {
            Collections.addAll(collection, "--versionType", "Launcher v" + Version.getVersion().getVersionString());
        }
        if (this.autoEnter) {
            if (version.compareTo(ClientProfileVersions.MINECRAFT_1_20) <= 0) {
                Collections.addAll(collection, "--server", this.profile.getServerAddress());
                Collections.addAll(collection, "--port", Integer.toString(this.profile.getServerPort()));
            } else {
                Collections.addAll(collection, "--quickPlayMultiplayer", String.format("%s:%d", this.profile.getServerAddress(), this.profile.getServerPort()));
            }
        }
        for (OptionalAction optionalAction : this.actions) {
            if (!(optionalAction instanceof OptionalActionClientArgs)) continue;
            collection.addAll(((OptionalActionClientArgs)optionalAction).args);
        }
        if (this.fullScreen) {
            Collections.addAll(collection, "--fullscreen", Boolean.toString(true));
        }
        if (this.width > 0 && this.height > 0) {
            Collections.addAll(collection, "--width", Integer.toString(this.width));
            Collections.addAll(collection, "--height", Integer.toString(this.height));
        }
    }
}

