/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.api;

import java.security.cert.X509Certificate;
import pro.gravit.launcher.client.ClientLauncherMethods;
import pro.gravit.launcher.client.utils.ApiBridgeService;
import pro.gravit.launcher.core.LauncherTrustManager;

public class CertificateService {
    private CertificateService() {
        throw new UnsupportedOperationException();
    }

    public static CheckClassResultApi checkClass(Class<?> clazz) throws SecurityException {
        X509Certificate[] x509CertificateArray = ClientLauncherMethods.getCertificates(clazz);
        if (x509CertificateArray == null) {
            return new CheckClassResultApi(CheckClassResultTypeApi.NOT_SIGNED, null, null);
        }
        try {
            return CheckClassResultApi.fromCheckClassResult(ApiBridgeService.checkCertificates(x509CertificateArray));
        }
        catch (Exception exception) {
            throw new SecurityException(exception);
        }
    }

    public static void checkClassSuccess(Class<?> clazz) {
        X509Certificate[] x509CertificateArray = ClientLauncherMethods.getCertificates(clazz);
        if (x509CertificateArray == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            ApiBridgeService.checkCertificatesSuccess(x509CertificateArray);
        }
        catch (Exception exception) {
            throw new SecurityException(exception);
        }
    }

    public static class CheckClassResultApi {
        public final CheckClassResultTypeApi type;
        public final X509Certificate endCertificate;
        public final X509Certificate rootCertificate;
        public final Exception exception;

        private CheckClassResultApi(CheckClassResultTypeApi checkClassResultTypeApi, X509Certificate x509Certificate, X509Certificate x509Certificate2) {
            this.type = checkClassResultTypeApi;
            this.endCertificate = x509Certificate;
            this.rootCertificate = x509Certificate2;
            this.exception = null;
        }

        private CheckClassResultApi(CheckClassResultTypeApi checkClassResultTypeApi, X509Certificate x509Certificate, X509Certificate x509Certificate2, Exception exception) {
            this.type = checkClassResultTypeApi;
            this.endCertificate = x509Certificate;
            this.rootCertificate = x509Certificate2;
            this.exception = exception;
        }

        private CheckClassResultApi(CheckClassResultApi checkClassResultApi) {
            this.type = checkClassResultApi.type;
            this.exception = checkClassResultApi.exception;
            this.rootCertificate = checkClassResultApi.rootCertificate;
            this.endCertificate = checkClassResultApi.endCertificate;
        }

        private static CheckClassResultApi fromCheckClassResult(LauncherTrustManager.CheckClassResult checkClassResult) {
            if (checkClassResult == null) {
                return null;
            }
            return new CheckClassResultApi(CheckClassResultApi.fromType(checkClassResult.type), checkClassResult.endCertificate, checkClassResult.rootCertificate, checkClassResult.exception);
        }

        private static CheckClassResultTypeApi fromType(LauncherTrustManager.CheckClassResultType checkClassResultType) {
            if (checkClassResultType == null) {
                return null;
            }
            return switch (checkClassResultType) {
                default -> throw new IncompatibleClassChangeError();
                case LauncherTrustManager.CheckClassResultType.NOT_SIGNED -> CheckClassResultTypeApi.NOT_SIGNED;
                case LauncherTrustManager.CheckClassResultType.SUCCESS -> CheckClassResultTypeApi.SUCCESS;
                case LauncherTrustManager.CheckClassResultType.UNTRUSTED -> CheckClassResultTypeApi.UNTRUSTED;
                case LauncherTrustManager.CheckClassResultType.UNVERIFED -> CheckClassResultTypeApi.UNVERIFED;
                case LauncherTrustManager.CheckClassResultType.UNCOMPAT -> CheckClassResultTypeApi.UNCOMPAT;
            };
        }
    }

    public static enum CheckClassResultTypeApi {
        NOT_SIGNED,
        SUCCESS,
        UNTRUSTED,
        UNVERIFED,
        UNCOMPAT,
        UNKNOWN;

    }
}

