/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import pro.gravit.utils.helper.LogHelper;

public final class CertificatePinningTrustManager {
    private static List<byte[]> secureConfigCertificates;
    private static X509Certificate[] certs;
    private static volatile TrustManagerFactory INSTANCE;

    private static X509Certificate[] getInternalCertificates() {
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            return new X509Certificate[0];
        }
        CertificateFactory certificateFactory2 = certificateFactory;
        return (X509Certificate[])secureConfigCertificates.stream().map(byArray -> {
            X509Certificate x509Certificate;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])byArray);
            try {
                x509Certificate = (X509Certificate)certificateFactory2.generateCertificate(byteArrayInputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException exception) {
                    LogHelper.error(exception);
                    return null;
                }
            }
            ((InputStream)byteArrayInputStream).close();
            return x509Certificate;
        }).toArray(X509Certificate[]::new);
    }

    public static X509Certificate[] getCertificates() {
        if (certs == null) {
            certs = CertificatePinningTrustManager.getInternalCertificates();
        }
        return Arrays.copyOf(certs, certs.length);
    }

    public static TrustManagerFactory getTrustManager() throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        if (certs == null) {
            certs = CertificatePinningTrustManager.getInternalCertificates();
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("X.509");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        int n = 1;
        for (X509Certificate x509Certificate : certs) {
            String string = Integer.toString(n);
            keyStore.setCertificateEntry(string, x509Certificate);
            ++n;
        }
        trustManagerFactory.init(keyStore);
        INSTANCE = trustManagerFactory;
        return trustManagerFactory;
    }

    static {
        certs = null;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(Base64.getDecoder().decode("MIIBSTCB8aADAgECAgEAMAoGCCqGSM49BAMCMDgxITAfBgNVBAMMGEtvbWFydVRFU1QgQXV0b2dlbmVyYXRlZDETMBEGA1UECgwKS29tYXJ1VEVTVDAeFw0yNjAxMDUwMDAwMDBaFw0zNjAxMDMwMDAwMDBaMA0xCzAJBgNVBAMMAmNhMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEdT1XDPWQUz4g+cJAyseD/5XfHJY0eIMvDgf2sV+QEBfuYoyAblzRBoKRwnjC8j7fTl3DFsTbK0/I9bS20Wj/IqMXMBUwEwYDVR0lBAwwCgYIKwYBBQUHAwMwCgYIKoZIzj0EAwIDRwAwRAIgCQlPiOx+otAyDh12RO3AqtTP4bp6m0HZms/L0j9UPT8CIAEy9+fzsZh8p3H4oM33qL+3oLv/CwfCiy1QyIk317Qq"));
        secureConfigCertificates = arrayList;
    }
}

