/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import pro.gravit.utils.helper.LogHelper;

public class LauncherTrustManager {
    private final X509Certificate[] trustSigners;
    private final List<X509Certificate> trustCache = new ArrayList<X509Certificate>();
    private static boolean isCertificatePinning = false;

    public LauncherTrustManager(X509Certificate[] x509CertificateArray) {
        this.trustSigners = x509CertificateArray;
        if (this.requireCustomTrustStore()) {
            this.injectCertificates();
        }
    }

    public LauncherTrustManager(List<byte[]> list) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        this.trustSigners = (X509Certificate[])list.stream().map(byArray -> {
            X509Certificate x509Certificate;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])byArray);
            try {
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)byteArrayInputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException exception) {
                    LogHelper.error(exception);
                    return null;
                }
            }
            ((InputStream)byteArrayInputStream).close();
            return x509Certificate;
        }).toArray(X509Certificate[]::new);
        if (this.requireCustomTrustStore()) {
            this.injectCertificates();
        }
    }

    private boolean requireCustomTrustStore() {
        return this.trustSigners != null && this.trustSigners.length != 0 && isCertificatePinning;
    }

    private void injectCertificates() {
        try {
            Map<String, Certificate> map = LauncherTrustManager.getDefaultKeyStore();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, new char[0]);
            Arrays.stream(this.trustSigners).forEach(x509Certificate -> LauncherTrustManager.setCertificateEntry(keyStore, "injected-certificate" + String.valueOf(UUID.randomUUID()), x509Certificate));
            map.keySet().forEach(string -> LauncherTrustManager.setCertificateEntry(keyStore, string, (Certificate)map.get(string)));
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            LogHelper.info("Successfully injected certificates to truststore");
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            LogHelper.error("Error while modify existing keystore");
        }
    }

    private static Map<String, Certificate> getDefaultKeyStore() {
        HashMap<String, Certificate> hashMap = new HashMap<String, Certificate>();
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            Path path = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts");
            keyStore.load(Files.newInputStream(path, new OpenOption[0]), "changeit".toCharArray());
            LauncherTrustManager.extractAllCertsAndPutInMap(keyStore, hashMap);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            LogHelper.warning("Error while loading existing keystore");
        }
        return hashMap;
    }

    private static void extractAllCertsAndPutInMap(KeyStore keyStore, Map<String, Certificate> map) {
        try {
            Collections.list(keyStore.aliases()).forEach(string -> LauncherTrustManager.extractCertAndPutInMap(keyStore, string, map));
        }
        catch (KeyStoreException keyStoreException) {
            LogHelper.error("Error during extraction certificates from default keystore");
        }
    }

    private static void setCertificateEntry(KeyStore keyStore, String string, Certificate certificate) {
        try {
            keyStore.setCertificateEntry(string, certificate);
        }
        catch (KeyStoreException keyStoreException) {
            LogHelper.warning("Something went wrong while adding certificate " + string);
        }
    }

    private static void extractCertAndPutInMap(KeyStore keyStore, String string, Map<String, Certificate> map) {
        try {
            if (keyStore.containsAlias(string)) {
                map.put(string, keyStore.getCertificate(string));
            }
        }
        catch (KeyStoreException keyStoreException) {
            LogHelper.warning("Error while extracting certificate " + string);
        }
    }

    public CheckClassResult checkCertificates(X509Certificate[] x509CertificateArray, CertificateChecker certificateChecker) {
        if (x509CertificateArray == null) {
            return new CheckClassResult(CheckClassResultType.NOT_SIGNED, null, null);
        }
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        X509Certificate x509Certificate2 = x509CertificateArray[0];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            X509Certificate x509Certificate3 = x509CertificateArray[i];
            if (this.trustCache.contains(x509Certificate3)) {
                this.trustCache.addAll(Arrays.asList(x509CertificateArray).subList(0, i));
                return new CheckClassResult(CheckClassResultType.SUCCESS, x509Certificate2, x509Certificate);
            }
            X509Certificate x509Certificate4 = i + 1 < x509CertificateArray.length ? x509CertificateArray[i + 1] : null;
            try {
                x509Certificate3.checkValidity();
            }
            catch (Exception exception) {
                return new CheckClassResult(CheckClassResultType.UNVERIFED, x509Certificate2, x509Certificate, exception);
            }
            if (x509Certificate4 != null) {
                try {
                    x509Certificate3.verify(x509Certificate4.getPublicKey());
                }
                catch (Exception exception) {
                    return new CheckClassResult(CheckClassResultType.UNVERIFED, x509Certificate2, x509Certificate, exception);
                }
            }
            try {
                if (this.isTrusted(x509Certificate3)) continue;
                return new CheckClassResult(CheckClassResultType.UNTRUSTED, x509Certificate2, x509Certificate);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return new CheckClassResult(CheckClassResultType.UNVERIFED, x509Certificate2, x509Certificate, certificateEncodingException);
            }
            try {
                certificateChecker.check(x509Certificate3, x509Certificate4, i);
                continue;
            }
            catch (Exception exception) {
                return new CheckClassResult(CheckClassResultType.UNCOMPAT, x509Certificate2, x509Certificate, exception);
            }
        }
        Collections.addAll(this.trustCache, x509CertificateArray);
        return new CheckClassResult(CheckClassResultType.SUCCESS, x509Certificate2, x509Certificate);
    }

    public void checkCertificatesSuccess(X509Certificate[] x509CertificateArray, CertificateChecker certificateChecker) throws Exception {
        CheckClassResult checkClassResult = this.checkCertificates(x509CertificateArray, certificateChecker);
        if (checkClassResult.type == CheckClassResultType.SUCCESS) {
            return;
        }
        if (checkClassResult.exception != null) {
            throw checkClassResult.exception;
        }
        throw new SecurityException(checkClassResult.type.name());
    }

    public boolean isTrusted(X509Certificate x509Certificate) throws CertificateEncodingException {
        for (X509Certificate x509Certificate2 : this.trustSigners) {
            if (!x509Certificate2.getSerialNumber().equals(x509Certificate.getSerialNumber()) || !Arrays.equals(x509Certificate2.getEncoded(), x509Certificate.getEncoded())) continue;
            return true;
        }
        return false;
    }

    public X509Certificate[] getTrusted() {
        return Arrays.copyOf(this.trustSigners, this.trustSigners.length);
    }

    public void isCertificateCodeSign(X509Certificate x509Certificate) {
        try {
            List<String> list = x509Certificate.getExtendedKeyUsage();
            if (list == null) {
                throw new SecurityException("Certificate extendedKeyUsage null");
            }
            boolean bl = false;
            for (String string : list) {
                if (!string.equals("1.3.6.1.5.5.7.3.3")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new SecurityException("Certificate extendedKeyUsage codeSign checkFailed");
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new SecurityException(certificateParsingException);
        }
    }

    public void isCertificateCA(X509Certificate x509Certificate) {
        if (x509Certificate.getBasicConstraints() < 0) {
            throw new SecurityException("This certificate not CA");
        }
    }

    public void stdCertificateChecker(X509Certificate x509Certificate, X509Certificate x509Certificate2, int n) {
        if (n == 0) {
            this.isCertificateCodeSign(x509Certificate);
        } else {
            this.isCertificateCA(x509Certificate);
        }
    }

    public static class CheckClassResult {
        public final CheckClassResultType type;
        public final X509Certificate endCertificate;
        public final X509Certificate rootCertificate;
        public final Exception exception;

        public CheckClassResult(CheckClassResultType checkClassResultType, X509Certificate x509Certificate, X509Certificate x509Certificate2) {
            this.type = checkClassResultType;
            this.endCertificate = x509Certificate;
            this.rootCertificate = x509Certificate2;
            this.exception = null;
        }

        public CheckClassResult(CheckClassResultType checkClassResultType, X509Certificate x509Certificate, X509Certificate x509Certificate2, Exception exception) {
            this.type = checkClassResultType;
            this.endCertificate = x509Certificate;
            this.rootCertificate = x509Certificate2;
            this.exception = exception;
        }

        public CheckClassResult(CheckClassResult checkClassResult) {
            this.type = checkClassResult.type;
            this.exception = checkClassResult.exception;
            this.rootCertificate = checkClassResult.rootCertificate;
            this.endCertificate = checkClassResult.endCertificate;
        }
    }

    public static enum CheckClassResultType {
        NOT_SIGNED,
        SUCCESS,
        UNTRUSTED,
        UNVERIFED,
        UNCOMPAT;

    }

    public static interface CertificateChecker {
        public void check(X509Certificate var1, X509Certificate var2, int var3) throws SecurityException;
    }
}

