/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core.serialize;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.utils.helper.IOHelper;

public final class HInput
implements AutoCloseable {
    public final InputStream stream;

    public HInput(byte[] byArray) {
        this.stream = new ByteArrayInputStream(byArray);
    }

    public HInput(InputStream inputStream) {
        this.stream = Objects.requireNonNull(inputStream, "stream");
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public String readASCII(int n) throws IOException {
        return IOHelper.decodeASCII(this.readByteArray(n));
    }

    public BigInteger readBigInteger(int n) throws IOException {
        return new BigInteger(this.readByteArray(n));
    }

    public boolean readBoolean() throws IOException {
        int n = this.readUnsignedByte();
        return switch (n) {
            case 0 -> false;
            case 1 -> true;
            default -> throw new IOException("Invalid boolean state: " + n);
        };
    }

    public byte[] readByteArray(int n) throws IOException {
        byte[] byArray = new byte[this.readLength(n)];
        IOHelper.read(this.stream, byArray);
        return byArray;
    }

    public int readInt() throws IOException {
        return (this.readUnsignedByte() << 24) + (this.readUnsignedByte() << 16) + (this.readUnsignedByte() << 8) + this.readUnsignedByte();
    }

    public int readLength(int n) throws IOException {
        if (n < 0) {
            return -n;
        }
        return IOHelper.verifyLength(this.readVarInt(), n);
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public short readShort() throws IOException {
        return (short)((this.readUnsignedByte() << 8) + this.readUnsignedByte());
    }

    public String readString(int n) throws IOException {
        return IOHelper.decode(this.readByteArray(n));
    }

    public int readUnsignedByte() throws IOException {
        int n = this.stream.read();
        if (n < 0) {
            throw new EOFException("readUnsignedByte");
        }
        return n;
    }

    public int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(this.readShort());
    }

    public UUID readUUID() throws IOException {
        return new UUID(this.readLong(), this.readLong());
    }

    public int readVarInt() throws IOException {
        int n = 0;
        for (int i = 0; i < 32; i += 7) {
            int n2 = this.readUnsignedByte();
            n |= (n2 & 0x7F) << i;
            if ((n2 & 0x80) != 0) continue;
            return n;
        }
        throw new IOException("VarInt too big");
    }

    public long readVarLong() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            int n = this.readUnsignedByte();
            l |= (long)(n & 0x7F) << i;
            if ((n & 0x80) != 0) continue;
            return l;
        }
        throw new IOException("VarLong too big");
    }
}

