/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.core.serialize.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import pro.gravit.launcher.core.serialize.HInput;
import pro.gravit.launcher.core.serialize.HOutput;
import pro.gravit.utils.helper.VerifyHelper;

public final class EnumSerializer<E extends Enum<?>> {
    private final Map<Integer, E> map = new HashMap<Integer, E>(16);

    public EnumSerializer(Class<E> clazz) {
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            VerifyHelper.putIfAbsent(this.map, ((Itf)((Object)enum_)).getNumber(), enum_, "Duplicate number for enum constant " + enum_.name());
        }
    }

    public static void write(HOutput hOutput, Itf itf) throws IOException {
        hOutput.writeVarInt(itf.getNumber());
    }

    public E read(HInput hInput) throws IOException {
        int n = hInput.readVarInt();
        return (E)((Enum)VerifyHelper.getMapValue(this.map, n, "Unknown enum number: " + n));
    }

    @FunctionalInterface
    public static interface Itf {
        public int getNumber();
    }
}

