/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.gui.RuntimeProvider;
import pro.gravit.launcher.runtime.utils.LauncherUpdater;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class StdJavaRuntimeProvider
implements RuntimeProvider {
    public static volatile Path updatePath;
    private static final AtomicReference<StdJavaRuntimeProvider> INSTANCE;

    public StdJavaRuntimeProvider() {
        INSTANCE.set(this);
    }

    public static StdJavaRuntimeProvider getInstance() {
        return INSTANCE.get();
    }

    public JavaFXApplication getApplication() {
        return JavaFXApplication.getInstance();
    }

    @Override
    public void run(String[] stringArray) {
        LogHelper.debug("Start JavaFX Application");
        Application.launch(JavaFXApplication.class, (String[])stringArray);
        LogHelper.debug("Post Application.launch method invoked");
        if (updatePath != null) {
            LauncherUpdater.nothing();
            LauncherEngine.beforeExit(0);
            Path path = IOHelper.getCodeSource(LauncherUpdater.class);
            try {
                try (InputStream inputStream = IOHelper.newInput(updatePath);
                     OutputStream outputStream = IOHelper.newOutput(path);){
                    IOHelper.transfer(inputStream, outputStream);
                }
                Files.deleteIfExists(updatePath);
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
                LauncherEngine.forceExit(-109);
            }
            LauncherUpdater.restart();
        }
    }

    @Override
    public void preLoad() {
    }

    protected void registerPrivateCommands() {
        JavaFXApplication javaFXApplication = JavaFXApplication.getInstance();
        if (javaFXApplication != null) {
            javaFXApplication.registerPrivateCommands();
        }
    }

    @Override
    public void init(boolean bl) {
    }

    static {
        INSTANCE = new AtomicReference();
    }
}

