/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.commands.runtime;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.stage.PrimaryStage;
import pro.gravit.utils.command.Command;

public class WarpCommand
extends Command {
    private JavaFXApplication application;

    public WarpCommand(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    @Override
    public String getArgsDescription() {
        return "[scene/overlay] [name]";
    }

    @Override
    public String getUsageDescription() {
        return "warp to any scene/overlay";
    }

    @Override
    public void invoke(String ... stringArray) throws Exception {
        this.verifyArgs(stringArray, 2);
        if (this.application == null) {
            this.application = JavaFXApplication.getInstance();
        }
        if (stringArray[0].equals("scene")) {
            AbstractScene abstractScene = (AbstractScene)this.application.gui.getByName(stringArray[1]);
            if (abstractScene == null) {
                throw new IllegalArgumentException("Scene %s not found".formatted(stringArray[1]));
            }
            PrimaryStage primaryStage = this.application.getMainStage();
            ContextHelper.runInFxThreadStatic(() -> {
                primaryStage.setScene(abstractScene, true);
                if (!primaryStage.isShowing()) {
                    primaryStage.show();
                }
            });
        } else if (stringArray[0].equals("overlay")) {
            AbstractOverlay abstractOverlay = (AbstractOverlay)this.application.gui.getByName(stringArray[1]);
            if (abstractOverlay == null) {
                throw new IllegalArgumentException("Overlay %s not found".formatted(stringArray[1]));
            }
            PrimaryStage primaryStage = this.application.getMainStage();
            if (primaryStage.isNullScene()) {
                throw new IllegalStateException("Please wrap to scene before");
            }
            AbstractScene abstractScene = (AbstractScene)primaryStage.getVisualComponent();
            ContextHelper.runInFxThreadStatic(() -> abstractScene.showOverlay(abstractOverlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {})));
        } else {
            throw new IllegalArgumentException("%s not found".formatted(stringArray[0]));
        }
    }
}

