/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.components;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.base.events.request.AssetUploadInfoRequestEvent;
import pro.gravit.launcher.base.request.cabinet.AssetUploadInfoRequest;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.utils.JavaFxUtils;
import pro.gravit.utils.helper.LogHelper;

public class UserBlock {
    private final JavaFXApplication application;
    private final Pane layout;
    private final AbstractScene.SceneAccessor sceneAccessor;
    private final ImageView avatar;
    private final Image originalAvatarImage;

    public UserBlock(Pane pane, AbstractScene.SceneAccessor sceneAccessor) {
        this.application = sceneAccessor.getApplication();
        this.layout = pane;
        this.sceneAccessor = sceneAccessor;
        this.avatar = (ImageView)LookupHelper.lookup((Node)pane, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)pane, "#avatar").ifPresent(imageView -> {
            try {
                JavaFxUtils.setStaticRadius(imageView, 8.0);
                imageView.setImage(this.originalAvatarImage);
            }
            catch (Throwable throwable) {
                LogHelper.warning("Skin head error");
            }
        });
        this.reset();
    }

    public void reset() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(label -> label.setText(this.application.authService.getUsername()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#role").ifPresent(label -> label.setText(this.application.authService.getMainRole()));
        this.avatar.setImage(this.originalAvatarImage);
        this.resetAvatar();
        if (this.application.authService.isFeatureAvailable("assetupload")) {
            LookupHelper.lookupIfPossible((Node)this.layout, "#customization").ifPresent(button -> {
                button.setVisible(true);
                button.setOnAction(actionEvent2 -> this.sceneAccessor.processRequest(this.application.getTranslation("runtime.overlay.processing.text.uploadassetinfo"), new AssetUploadInfoRequest(), assetUploadInfoRequestEvent -> this.sceneAccessor.runInFxThread(() -> this.sceneAccessor.showOverlay(this.application.gui.uploadAssetOverlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.application.gui.uploadAssetOverlay.onAssetUploadInfo((AssetUploadInfoRequestEvent)assetUploadInfoRequestEvent)))), this.sceneAccessor::errorHandle, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {})));
            });
        }
    }

    public void resetAvatar() {
        if (this.avatar == null) {
            return;
        }
        JavaFxUtils.putAvatarToImageView(this.application, this.application.authService.getUsername(), this.avatar);
    }
}

