/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.gui.config.GuiModuleConfig;
import pro.gravit.launcher.gui.service.JavaService;
import pro.gravit.launcher.gui.utils.SystemTheme;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.launcher.runtime.client.UserSettings;
import pro.gravit.utils.helper.JavaHelper;

public class RuntimeSettings
extends UserSettings {
    public static final LAUNCHER_LOCALE DEFAULT_LOCALE = LAUNCHER_LOCALE.RUSSIAN;
    public transient Path updatesDir;
    @LauncherNetworkAPI
    public String login;
    @LauncherNetworkAPI
    public AuthRequest.AuthPasswordInterface password;
    @LauncherNetworkAPI
    public boolean autoAuth;
    @LauncherNetworkAPI
    public GetAvailabilityAuthRequestEvent.AuthAvailability lastAuth;
    @LauncherNetworkAPI
    public String updatesDirPath;
    @LauncherNetworkAPI
    public UUID lastProfile;
    @LauncherNetworkAPI
    public volatile LAUNCHER_LOCALE locale;
    @LauncherNetworkAPI
    public String oauthAccessToken;
    @LauncherNetworkAPI
    public String oauthRefreshToken;
    @LauncherNetworkAPI
    public long oauthExpire;
    @LauncherNetworkAPI
    public volatile LAUNCHER_THEME theme = LAUNCHER_THEME.COMMON;
    @LauncherNetworkAPI
    public Map<UUID, ProfileSettings> profileSettings = new HashMap<UUID, ProfileSettings>();
    @LauncherNetworkAPI
    public List<ClientProfile> profiles;
    @LauncherNetworkAPI
    public GlobalSettings globalSettings = new GlobalSettings();

    public static RuntimeSettings getDefault(GuiModuleConfig guiModuleConfig) {
        RuntimeSettings runtimeSettings = new RuntimeSettings();
        runtimeSettings.autoAuth = false;
        runtimeSettings.updatesDir = DirBridge.defaultUpdatesDir;
        runtimeSettings.locale = guiModuleConfig.locale == null ? LAUNCHER_LOCALE.RUSSIAN : LAUNCHER_LOCALE.valueOf(guiModuleConfig.locale);
        try {
            runtimeSettings.theme = SystemTheme.getSystemTheme();
        }
        catch (Throwable throwable) {
            runtimeSettings.theme = LAUNCHER_THEME.COMMON;
        }
        return runtimeSettings;
    }

    public void apply() {
        if (this.updatesDirPath != null) {
            this.updatesDir = Paths.get(this.updatesDirPath, new String[0]);
        }
    }

    public static enum LAUNCHER_THEME {
        COMMON(null, "default"),
        DARK("dark", "dark");

        public final String name;
        public final String displayName;

        private LAUNCHER_THEME(String string2, String string3) {
            this.name = string2;
            this.displayName = string3;
        }
    }

    public static class GlobalSettings {
        @LauncherNetworkAPI
        public boolean prismVSync = true;
        @LauncherNetworkAPI
        public boolean debugAllClients = false;
    }

    public static enum LAUNCHER_LOCALE {
        RUSSIAN("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439"),
        BELARUSIAN("be", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f"),
        UKRAINIAN("uk", "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430"),
        POLISH("pl", "Polska"),
        ENGLISH("en", "English");

        public final String name;
        public final String displayName;

        private LAUNCHER_LOCALE(String string2, String string3) {
            this.name = string2;
            this.displayName = string3;
        }
    }

    public static class ProfileSettingsView {
        private final transient ProfileSettings settings;
        public int ram;
        public boolean debug;
        public boolean fullScreen;
        public boolean autoEnter;
        public String javaPath;
        public boolean waylandSupport;
        public boolean debugSkipUpdate;
        public boolean debugSkipFileMonitor;

        public ProfileSettingsView(ProfileSettings profileSettings) {
            this.ram = profileSettings.ram;
            this.debug = profileSettings.debug;
            this.fullScreen = profileSettings.fullScreen;
            this.autoEnter = profileSettings.autoEnter;
            this.javaPath = profileSettings.javaPath;
            this.waylandSupport = profileSettings.waylandSupport;
            this.debugSkipUpdate = profileSettings.debugSkipUpdate;
            this.debugSkipFileMonitor = profileSettings.debugSkipFileMonitor;
            this.settings = profileSettings;
        }

        public void apply() {
            this.settings.ram = this.ram;
            this.settings.debug = this.debug;
            this.settings.autoEnter = this.autoEnter;
            this.settings.fullScreen = this.fullScreen;
            this.settings.javaPath = this.javaPath;
            this.settings.waylandSupport = this.waylandSupport;
            this.settings.debugSkipUpdate = this.debugSkipUpdate;
            this.settings.debugSkipFileMonitor = this.debugSkipFileMonitor;
        }
    }

    public static class ProfileSettings {
        @LauncherNetworkAPI
        public int ram;
        @LauncherNetworkAPI
        public boolean debug;
        @LauncherNetworkAPI
        public boolean fullScreen;
        @LauncherNetworkAPI
        public boolean autoEnter;
        @LauncherNetworkAPI
        public String javaPath;
        @LauncherNetworkAPI
        public boolean waylandSupport;
        @LauncherNetworkAPI
        public boolean debugSkipUpdate;
        @LauncherNetworkAPI
        public boolean debugSkipFileMonitor;

        public static ProfileSettings getDefault(JavaService javaService, ClientProfile clientProfile) {
            ProfileSettings profileSettings = new ProfileSettings();
            ClientProfile.ProfileDefaultSettings profileDefaultSettings = clientProfile.getSettings();
            profileSettings.ram = profileDefaultSettings.ram;
            profileSettings.autoEnter = profileDefaultSettings.autoEnter;
            profileSettings.fullScreen = profileDefaultSettings.fullScreen;
            JavaHelper.JavaVersion javaVersion = javaService.getRecommendJavaVersion(clientProfile);
            if (javaVersion != null) {
                profileSettings.javaPath = javaVersion.jvmDir.toString();
            }
            profileSettings.debugSkipUpdate = false;
            profileSettings.debugSkipFileMonitor = false;
            return profileSettings;
        }
    }
}

