/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.utils.JavaFxUtils;
import pro.gravit.utils.helper.LogHelper;

public abstract class AbstractStage {
    protected final JavaFXApplication application;
    protected final Stage stage;
    protected final Scene scene;
    protected final StackPane stackPane;
    protected AbstractVisualComponent visualComponent;
    protected AbstractVisualComponent background;
    protected Pane disablePane;
    protected VBox notificationsVBox;
    protected AnchorPane notifications;
    private final AtomicInteger disableCounter = new AtomicInteger(0);
    protected final AtomicInteger scenePosition = new AtomicInteger(0);
    protected List<String> sceneFlow = new LinkedList<String>();

    protected AbstractStage(JavaFXApplication javaFXApplication, Stage stage) {
        this.application = javaFXApplication;
        this.stage = stage;
        this.stackPane = new StackPane();
        this.scene = new Scene((Parent)this.stackPane);
        this.stage.setScene(this.scene);
        this.resetStyles();
    }

    protected void setClipRadius(double d, double d2) {
        Rectangle rectangle = new Rectangle(this.stackPane.getPrefWidth(), this.stackPane.getPrefHeight());
        rectangle.heightProperty().bind((ObservableValue)this.stackPane.heightProperty());
        rectangle.widthProperty().bind((ObservableValue)this.stackPane.widthProperty());
        rectangle.setArcHeight(d2);
        rectangle.setArcWidth(d);
        this.stackPane.setClip((Node)rectangle);
    }

    public void hide() {
        this.stage.setIconified(true);
    }

    public void close() {
        this.stage.hide();
    }

    public void resetStyles() {
        try {
            this.scene.getStylesheets().clear();
            this.scene.getStylesheets().add((Object)JavaFxUtils.getStyleUrl("styles/variables").toString());
            this.scene.getStylesheets().add((Object)JavaFxUtils.getStyleUrl("styles/global").toString());
        }
        catch (IOException iOException) {
            LogHelper.error(iOException);
        }
    }

    public void enableMouseDrag(Node node) {
        AtomicReference atomicReference = new AtomicReference();
        node.setOnMousePressed(mouseEvent -> atomicReference.set(new Point2D(mouseEvent.getSceneX(), mouseEvent.getSceneY())));
        node.setOnMouseDragged(mouseEvent -> {
            if (atomicReference.get() == null) {
                return;
            }
            this.stage.setX(mouseEvent.getScreenX() - ((Point2D)atomicReference.get()).getX());
            this.stage.setY(mouseEvent.getScreenY() - ((Point2D)atomicReference.get()).getY());
        });
    }

    public AbstractVisualComponent getVisualComponent() {
        return this.visualComponent;
    }

    public void setScene(AbstractVisualComponent abstractVisualComponent, boolean bl) throws Exception {
        if (abstractVisualComponent == null) {
            if (!this.stackPane.getChildren().isEmpty()) {
                this.stackPane.getChildren().set(this.scenePosition.get(), (Object)new Pane());
            }
            return;
        }
        if (bl) {
            this.sceneFlow.add(abstractVisualComponent.getName());
        }
        abstractVisualComponent.currentStage = this;
        if (!abstractVisualComponent.isInit()) {
            abstractVisualComponent.init();
        }
        if (abstractVisualComponent.isResetOnShow) {
            abstractVisualComponent.reset();
        }
        if (this.stackPane.getChildren().isEmpty()) {
            this.stackPane.getChildren().add((Object)abstractVisualComponent.getFxmlRoot());
        } else {
            Node node = (Node)this.stackPane.getChildren().get(this.scenePosition.get());
            Effect effect = node.getEffect();
            if (effect instanceof GaussianBlur) {
                GaussianBlur gaussianBlur = (GaussianBlur)effect;
                node.setEffect(null);
                abstractVisualComponent.getFxmlRootPrivate().setEffect((Effect)gaussianBlur);
            }
            this.stackPane.getChildren().set(this.scenePosition.get(), (Object)abstractVisualComponent.getFxmlRoot());
        }
        this.stage.sizeToScene();
        abstractVisualComponent.postInit();
        this.visualComponent = abstractVisualComponent;
    }

    public AbstractVisualComponent back() throws Exception {
        AbstractVisualComponent abstractVisualComponent;
        if (this.sceneFlow.size() <= 1) {
            return null;
        }
        do {
            String string;
            if ((abstractVisualComponent = this.application.gui.getByName(string = this.sceneFlow.get(this.sceneFlow.size() - 2))) == null) {
                return null;
            }
            this.sceneFlow.remove(this.sceneFlow.get(this.sceneFlow.size() - 1));
        } while (abstractVisualComponent.isDisableReturnBack());
        this.setScene(abstractVisualComponent, false);
        return abstractVisualComponent;
    }

    public void push(Node node) {
        this.stackPane.getChildren().add((Object)node);
    }

    public boolean contains(Node node) {
        return this.stackPane.getChildren().contains((Object)node);
    }

    public void pull(Node node) {
        this.stackPane.getChildren().remove((Object)node);
    }

    public void addAfter(Node node, Node node2) {
        int n = this.stackPane.getChildren().indexOf((Object)node);
        if (n >= 0) {
            this.stackPane.getChildren().add(n + 1, (Object)node2);
        }
    }

    public void addBefore(Node node, Node node2) {
        int n = this.stackPane.getChildren().indexOf((Object)node);
        if (n >= 0) {
            this.stackPane.getChildren().add(n, (Object)node2);
        }
    }

    public int getScenePosition() {
        return this.scenePosition.get();
    }

    protected void pushNotification(Node node) {
        if (this.notifications == null) {
            this.notifications = new AnchorPane();
            this.notificationsVBox = new VBox();
            this.notificationsVBox.setAlignment(Pos.BOTTOM_RIGHT);
            this.notifications.setPickOnBounds(false);
            this.notificationsVBox.setPickOnBounds(false);
            this.notifications.getChildren().add((Object)this.notificationsVBox);
            AnchorPane.setRightAnchor((Node)this.notificationsVBox, (Double)10.0);
            AnchorPane.setTopAnchor((Node)this.notificationsVBox, (Double)10.0);
            AnchorPane.setBottomAnchor((Node)this.notificationsVBox, (Double)10.0);
            this.notificationsVBox.setSpacing(10.0);
            this.push((Node)this.notifications);
        }
        this.notificationsVBox.getChildren().add((Object)node);
    }

    protected void pullNotification(Node node) {
        if (this.notifications != null) {
            this.notificationsVBox.getChildren().remove((Object)node);
        }
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    public final boolean isNullScene() {
        return this.visualComponent == null;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void show() {
        this.stage.show();
    }

    public void disable() {
        int n = this.disableCounter.incrementAndGet();
        LogHelper.dev("Disable scene: stack_num: %s | blur: %s | counter: %s", this.stackPane.getChildren().size(), this.disablePane == null ? "null" : "not null", n);
        if (n != 1) {
            return;
        }
        Pane pane = (Pane)this.stackPane.getChildren().get(this.scenePosition.get());
        pane.setEffect((Effect)new GaussianBlur(150.0));
        if (this.disablePane == null) {
            this.disablePane = new Pane();
            this.disablePane.setPrefHeight(pane.getPrefHeight());
            this.disablePane.setPrefWidth(pane.getPrefWidth());
            this.addAfter((Node)pane, (Node)this.disablePane);
        }
        this.disablePane.setVisible(true);
    }

    public void enable() {
        int n = this.disableCounter.decrementAndGet();
        LogHelper.dev("Enable scene: stack_num: %s | blur: %s | counter: %s", this.stackPane.getChildren().size(), this.disablePane == null ? "null" : "not null", n);
        if (n != 0) {
            return;
        }
        Pane pane = (Pane)this.stackPane.getChildren().get(this.scenePosition.get());
        pane.setEffect(null);
        this.disablePane.setVisible(false);
    }
}

