/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;

public class ContextHelper {
    private final AbstractVisualComponent pane;

    ContextHelper(AbstractVisualComponent abstractVisualComponent) {
        this.pane = abstractVisualComponent;
    }

    public static <T> CompletableFuture<T> runInFxThreadStatic(GuiExceptionCallback<T> guiExceptionCallback) {
        CompletableFuture completableFuture = new CompletableFuture();
        if (Platform.isFxApplicationThread()) {
            try {
                completableFuture.complete(guiExceptionCallback.call());
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
        } else {
            Platform.runLater(() -> {
                try {
                    completableFuture.complete(guiExceptionCallback.call());
                }
                catch (Throwable throwable) {
                    completableFuture.completeExceptionally(throwable);
                }
            });
        }
        return completableFuture;
    }

    public <T> T runCallback(GuiExceptionCallback<T> guiExceptionCallback) {
        try {
            return guiExceptionCallback.call();
        }
        catch (Throwable throwable) {
            this.errorHandling(throwable);
            return null;
        }
    }

    public void runCallback(GuiExceptionRunnable guiExceptionRunnable) {
        try {
            guiExceptionRunnable.call();
        }
        catch (Throwable throwable) {
            this.errorHandling(throwable);
        }
    }

    public static CompletableFuture<Void> runInFxThreadStatic(GuiExceptionRunnable guiExceptionRunnable) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (Platform.isFxApplicationThread()) {
            try {
                guiExceptionRunnable.call();
                completableFuture.complete(null);
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
        } else {
            Platform.runLater(() -> {
                try {
                    guiExceptionRunnable.call();
                    completableFuture.complete(null);
                }
                catch (Throwable throwable) {
                    completableFuture.completeExceptionally(throwable);
                }
            });
        }
        return completableFuture;
    }

    public final <T> CompletableFuture<T> runInFxThread(GuiExceptionCallback<T> guiExceptionCallback) {
        return ContextHelper.runInFxThreadStatic(guiExceptionCallback).exceptionally(throwable -> {
            this.errorHandling((Throwable)throwable);
            return null;
        });
    }

    public final CompletableFuture<Void> runInFxThread(GuiExceptionRunnable guiExceptionRunnable) {
        return ContextHelper.runInFxThreadStatic(guiExceptionRunnable).exceptionally(throwable -> {
            this.errorHandling((Throwable)throwable);
            return null;
        });
    }

    final void errorHandling(Throwable throwable) {
        if (this.pane != null) {
            this.pane.errorHandle(throwable);
        }
    }

    public static interface GuiExceptionCallback<T> {
        public T call() throws Throwable;
    }

    public static interface GuiExceptionRunnable {
        public void call() throws Throwable;
    }
}

