/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class FXMLFactory {
    private final ResourceBundle resources;
    private final ExecutorService executorService;

    public FXMLFactory(ResourceBundle resourceBundle, ExecutorService executorService) {
        this.resources = resourceBundle;
        this.executorService = executorService;
    }

    public <T extends Node> CompletableFuture<T> getAsync(String string) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.get(string);
            }
            catch (IOException iOException) {
                throw new FXMLLoadException(iOException);
            }
        }, this.executorService);
    }

    public <T extends Node> T get(String string) throws IOException {
        long l = System.currentTimeMillis();
        FXMLLoader fXMLLoader = this.newLoaderInstance(JavaFXApplication.getResourceURL(string));
        long l2 = System.currentTimeMillis();
        try (InputStream inputStream = IOHelper.newInput(JavaFXApplication.getResourceURL(string));){
            Node node = (Node)fXMLLoader.load(inputStream);
            long l3 = System.currentTimeMillis();
            LogHelper.debug("Fxml load %s time: c: %d | l: %d | total: %d", string, l2 - l, l3 - l2, l3 - l);
            Node node2 = node;
            return (T)node2;
        }
    }

    public FXMLLoader newLoaderInstance(URL uRL) {
        FXMLLoader fXMLLoader;
        try {
            fXMLLoader = new FXMLLoader(uRL);
            if (this.resources != null) {
                fXMLLoader.setResources(this.resources);
            }
        }
        catch (Exception exception) {
            LogHelper.error(exception);
            return null;
        }
        fXMLLoader.setCharset(IOHelper.UNICODE_CHARSET);
        fXMLLoader.setClassLoader(FXMLFactory.class.getClassLoader());
        return fXMLLoader;
    }

    public static class FXMLLoadException
    extends RuntimeException {
        public FXMLLoadException() {
        }

        public FXMLLoadException(String string) {
            super(string);
        }

        public FXMLLoadException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public FXMLLoadException(Throwable throwable) {
            super(throwable);
        }
    }
}

