/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.gui.dialogs.ApplyDialog;
import pro.gravit.launcher.gui.dialogs.InfoDialog;
import pro.gravit.launcher.gui.dialogs.NotificationDialog;
import pro.gravit.launcher.gui.helper.PositionHelper;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.stage.DialogStage;
import pro.gravit.launcher.gui.stage.PrimaryStage;

public class MessageManager {
    public final JavaFXApplication application;

    public MessageManager(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public void createNotification(String string, String string2) {
        this.createNotification(string, string2, this.application.getCurrentScene() != null);
    }

    public void initDialogInScene(AbstractScene abstractScene, AbstractDialog abstractDialog) {
        Pane pane = (Pane)abstractDialog.getFxmlRootPrivate();
        if (!abstractDialog.isInit()) {
            try {
                abstractDialog.currentStage = abstractScene.currentStage;
                abstractDialog.init();
            }
            catch (Exception exception) {
                abstractScene.errorHandle(exception);
            }
        }
        abstractDialog.setOnClose(() -> {
            abstractScene.currentStage.pull((Node)pane);
            abstractScene.currentStage.enable();
        });
        abstractScene.disable();
        abstractScene.currentStage.push((Node)pane);
    }

    public void createNotification(String string, String string2, boolean bl) {
        NotificationDialog notificationDialog = new NotificationDialog(this.application, string, string2);
        if (bl) {
            PrimaryStage primaryStage = this.application.getMainStage();
            if (primaryStage == null) {
                throw new NullPointerException("Try show launcher notification in application.getMainStage() == null");
            }
            ContextHelper.runInFxThreadStatic(() -> {
                notificationDialog.init();
                primaryStage.pushNotification((Node)notificationDialog.getFxmlRootPrivate());
                notificationDialog.setOnClose(() -> primaryStage.pullNotification((Node)notificationDialog.getFxmlRootPrivate()));
            });
        } else {
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            ContextHelper.runInFxThreadStatic(() -> {
                NotificationDialog.NotificationSlot notificationSlot = new NotificationDialog.NotificationSlot(d -> ((DialogStage)atomicReference.get()).stage.setY(((DialogStage)atomicReference.get()).stage.getY() + d), ((Pane)notificationDialog.getFxmlRootPrivate()).getPrefHeight() + 20.0);
                notificationDialog.setPosition(PositionHelper.PositionInfo.BOTTOM_RIGHT, notificationSlot);
                notificationDialog.setOnClose(() -> {
                    ((DialogStage)atomicReference.get()).close();
                    ((DialogStage)atomicReference.get()).stage.setScene(null);
                });
                atomicReference.set(new DialogStage(this.application, string, notificationDialog));
                ((DialogStage)atomicReference.get()).show();
            });
        }
    }

    public void showDialog(String string, String string2, Runnable runnable, Runnable runnable2, boolean bl) {
        InfoDialog infoDialog = new InfoDialog(this.application, string, string2, runnable, runnable2);
        this.showAbstractDialog(infoDialog, string, bl);
    }

    public void showApplyDialog(String string, String string2, Runnable runnable, Runnable runnable2, boolean bl) {
        this.showApplyDialog(string, string2, runnable, runnable2, runnable2, bl);
    }

    public void showApplyDialog(String string, String string2, Runnable runnable, Runnable runnable2, Runnable runnable3, boolean bl) {
        ApplyDialog applyDialog = new ApplyDialog(this.application, string, string2, runnable, runnable2, runnable3);
        this.showAbstractDialog(applyDialog, string, bl);
    }

    public void showAbstractDialog(AbstractDialog abstractDialog, String string, boolean bl) {
        if (bl) {
            AbstractScene abstractScene = this.application.getCurrentScene();
            if (abstractScene == null) {
                throw new NullPointerException("Try show launcher dialog in application.getCurrentScene() == null");
            }
            ContextHelper.runInFxThreadStatic(() -> this.initDialogInScene(abstractScene, abstractDialog));
        } else {
            AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
            ContextHelper.runInFxThreadStatic(() -> {
                atomicReference.set(new DialogStage(this.application, string, abstractDialog));
                ((DialogStage)atomicReference.get()).show();
            });
            abstractDialog.setOnClose(() -> {
                ((DialogStage)atomicReference.get()).close();
                ((DialogStage)atomicReference.get()).stage.setScene(null);
            });
        }
    }
}

