/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.util.Locale;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalFile;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.base.profiles.optional.triggers.OptionalTriggerContext;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.utils.helper.JavaHelper;

public class TriggerManager {
    private final JavaFXApplication application;

    public TriggerManager(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public void process(ClientProfile clientProfile, OptionalView optionalView) {
        TriggerManagerContext triggerManagerContext = new TriggerManagerContext(clientProfile);
        for (OptionalFile optionalFile : optionalView.all) {
            if (optionalFile.limited) {
                if (!this.application.authService.checkPermission("launcher.runtime.optionals.%s.%s.show".formatted(clientProfile.getUUID(), optionalFile.name.toLowerCase(Locale.ROOT)))) {
                    optionalView.disable(optionalFile, null);
                    optionalFile.visible = false;
                } else {
                    optionalFile.visible = true;
                }
            }
            if (optionalFile.triggersList == null) continue;
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            for (OptionalTrigger optionalTrigger : optionalFile.triggersList) {
                if (optionalTrigger.required) {
                    bl = true;
                }
                if (optionalTrigger.check(optionalFile, triggerManagerContext)) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            if (bl) {
                if (n2 == 0) {
                    optionalView.enable(optionalFile, true, null);
                    continue;
                }
                optionalView.disable(optionalFile, null);
                continue;
            }
            if (n <= 0) continue;
            optionalView.enable(optionalFile, false, null);
        }
    }

    private class TriggerManagerContext
    implements OptionalTriggerContext {
        private final ClientProfile profile;

        private TriggerManagerContext(ClientProfile clientProfile) {
            this.profile = clientProfile;
        }

        @Override
        public ClientProfile getProfile() {
            return this.profile;
        }

        @Override
        public String getUsername() {
            return TriggerManager.this.application.authService.getUsername();
        }

        @Override
        public JavaHelper.JavaVersion getJavaVersion() {
            RuntimeSettings.ProfileSettings profileSettings = TriggerManager.this.application.getProfileSettings(this.profile);
            for (JavaHelper.JavaVersion javaVersion : TriggerManager.this.application.javaService.javaVersions) {
                if (profileSettings.javaPath == null || !profileSettings.javaPath.equals(javaVersion.jvmDir.toString())) continue;
                return javaVersion;
            }
            return JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
    }
}

