/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.overlays;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractStage;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.overlays.AbstractOverlay;
import pro.gravit.utils.helper.LogHelper;

public class ProcessingOverlay
extends AbstractOverlay {
    private Labeled description;

    public ProcessingOverlay(JavaFXApplication javaFXApplication) {
        super("overlay/processing/processing.fxml", javaFXApplication);
    }

    @Override
    public String getName() {
        return "processing";
    }

    @Override
    protected void doInit() {
        this.description = (Labeled)LookupHelper.lookup((Node)this.layout, "#description");
    }

    @Override
    public void reset() {
        this.description.textProperty().unbind();
        this.description.getStyleClass().remove((Object)"error");
        this.description.setText("...");
    }

    @Override
    public void errorHandle(Throwable throwable) {
        super.errorHandle(throwable);
        this.description.textProperty().unbind();
        this.description.getStyleClass().add((Object)"error");
        this.description.setText(throwable.toString());
    }

    public final <T extends WebSocketEvent> void processRequest(AbstractStage abstractStage, String string, Request<T> request, Consumer<T> consumer, EventHandler<ActionEvent> eventHandler) {
        this.processRequest(abstractStage, string, request, consumer, null, eventHandler);
    }

    public final <T extends WebSocketEvent> void processRequest(AbstractStage abstractStage, String string, Request<T> request, Consumer<T> consumer, Consumer<Throwable> consumer2, EventHandler<ActionEvent> eventHandler) {
        try {
            ContextHelper.runInFxThreadStatic(() -> this.show(abstractStage, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
                try {
                    this.description.setText(string);
                    ((CompletableFuture)this.application.service.request(request).thenAccept(webSocketEvent -> {
                        LogHelper.dev("RequestFuture complete normally");
                        consumer.accept(webSocketEvent);
                        ContextHelper.runInFxThreadStatic(() -> this.hide(0.0, null));
                    })).exceptionally(throwable -> {
                        if (consumer2 != null) {
                            consumer2.accept((Throwable)throwable);
                        } else {
                            ContextHelper.runInFxThreadStatic(() -> this.errorHandle(throwable.getCause()));
                        }
                        ContextHelper.runInFxThreadStatic(() -> this.hide(2500.0, eventHandler));
                        return null;
                    });
                }
                catch (IOException iOException) {
                    this.errorHandle(iOException);
                    this.hide(2500.0, eventHandler);
                }
            })));
        }
        catch (Exception exception) {
            ContextHelper.runInFxThreadStatic(() -> this.errorHandle(exception));
        }
    }
}

