/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.overlays;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.events.request.AssetUploadInfoRequestEvent;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.cabinet.GetAssetUploadUrl;
import pro.gravit.launcher.core.LauncherNetworkAPI;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.overlays.CenterOverlay;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class UploadAssetOverlay
extends CenterOverlay {
    private static final HttpClient client = HttpClient.newBuilder().build();
    private Button uploadSkin;
    private Button uploadCape;
    private CheckBox useSlim;
    private AssetUploadInfoRequestEvent.SlimSupportConf slimSupportConf;

    public UploadAssetOverlay(JavaFXApplication javaFXApplication) {
        super("overlay/uploadasset/uploadasset.fxml", javaFXApplication);
    }

    @Override
    public String getName() {
        return "uploadasset";
    }

    @Override
    protected void doInit() {
        this.uploadSkin = (Button)LookupHelper.lookup((Node)this.layout, "#uploadskin");
        this.uploadCape = (Button)LookupHelper.lookup((Node)this.layout, "#uploadcape");
        this.useSlim = (CheckBox)LookupHelper.lookup((Node)this.layout, "#useslim");
        this.uploadSkin.setOnAction(actionEvent -> this.uploadAsset("SKIN", switch (this.slimSupportConf) {
            default -> throw new IncompatibleClassChangeError();
            case AssetUploadInfoRequestEvent.SlimSupportConf.USER -> new AssetOptions(this.useSlim.isSelected());
            case AssetUploadInfoRequestEvent.SlimSupportConf.UNSUPPORTED, AssetUploadInfoRequestEvent.SlimSupportConf.SERVER -> null;
        }));
        this.uploadCape.setOnAction(actionEvent -> this.uploadAsset("CAPE", null));
        LookupHelper.lookupIfPossible((Node)this.layout, "#close").ifPresent(button -> button.setOnAction(actionEvent -> this.hide(0.0, null)));
    }

    public void onAssetUploadInfo(AssetUploadInfoRequestEvent assetUploadInfoRequestEvent) {
        boolean bl = assetUploadInfoRequestEvent.available.contains("SKIN");
        boolean bl2 = assetUploadInfoRequestEvent.available.contains("CAPE");
        this.uploadSkin.setVisible(bl);
        this.uploadCape.setVisible(bl2);
        this.slimSupportConf = assetUploadInfoRequestEvent.slimSupportConf;
        if (bl) {
            switch (assetUploadInfoRequestEvent.slimSupportConf) {
                case USER: {
                    this.useSlim.setVisible(true);
                    break;
                }
                case UNSUPPORTED: 
                case SERVER: {
                    this.useSlim.setVisible(false);
                }
            }
        }
    }

    public void uploadAsset(String string, AssetOptions assetOptions) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("PNG Image", new String[]{"*.png"}));
        File file = fileChooser.showOpenDialog((Window)this.currentStage.getStage());
        if (file == null) {
            return;
        }
        this.application.gui.processingOverlay.processRequest(this.currentStage, this.application.getTranslation("runtime.overlay.processing.text.uploadasset"), new GetAssetUploadUrl(string), getAssetUploadUrlRequestEvent -> {
            byte[] byArray;
            Object object;
            String string2 = getAssetUploadUrlRequestEvent.token == null ? Request.getAccessToken() : getAssetUploadUrlRequestEvent.token.accessToken;
            String string3 = SecurityHelper.toHex(SecurityHelper.randomBytes(32));
            String string4 = assetOptions != null ? Launcher.gsonManager.gson.toJson(assetOptions) : "{}";
            try {
                object = new ByteArrayOutputStream(256);
                try {
                    ((OutputStream)object).write("--".getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write(string3.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write("\r\nContent-Disposition: form-data; name=\"options\"\r\nContent-Type: application/json\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write(string4.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write("\r\n--".getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write(string3.getBytes(StandardCharsets.UTF_8));
                    ((OutputStream)object).write("\r\nContent-Disposition: form-data; name=\"file\"; filename=\"file\"\r\nContent-Type: image/png\r\n\r\n".getBytes(StandardCharsets.UTF_8));
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                }
                finally {
                    ((ByteArrayOutputStream)object).close();
                }
            }
            catch (IOException iOException) {
                this.errorHandle(iOException);
                return;
            }
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);){
                byteArrayOutputStream.write("\r\n--".getBytes(StandardCharsets.UTF_8));
                byteArrayOutputStream.write(string3.getBytes(StandardCharsets.UTF_8));
                byteArrayOutputStream.write("--\r\n".getBytes(StandardCharsets.UTF_8));
                object = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                this.errorHandle(iOException);
                return;
            }
            LogHelper.dev("%s<DATA>%s", new String(byArray), new String((byte[])object));
            try {
                ((CompletableFuture)client.sendAsync(HttpRequest.newBuilder().uri(URI.create(getAssetUploadUrlRequestEvent.url)).POST(HttpRequest.BodyPublishers.concat(HttpRequest.BodyPublishers.ofByteArray(byArray), HttpRequest.BodyPublishers.ofFile(file.toPath()), HttpRequest.BodyPublishers.ofByteArray((byte[])object))).header("Authorization", "Bearer " + string2).header("Content-Type", "multipart/form-data; boundary=\"" + string3 + "\"").header("Accept", "application/json").build(), HttpResponse.BodyHandlers.ofByteArray()).thenAccept(httpResponse -> {
                    LogHelper.dev(new String((byte[])httpResponse.body()));
                    if (httpResponse.statusCode() >= 200 && httpResponse.statusCode() < 300) {
                        try (InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream((byte[])httpResponse.body()));){
                            Texture texture = Launcher.gsonManager.gson.fromJson((Reader)inputStreamReader, UserTexture.class).toLauncherTexture();
                            URI uRI = new URI(texture.url);
                            if ("SKIN".equals(string)) {
                                this.application.skinManager.addOrReplaceSkin(this.application.authService.getUsername(), uRI);
                                for (AbstractVisualComponent abstractVisualComponent : this.application.gui.getComponents()) {
                                    if (!abstractVisualComponent.isInit() || !(abstractVisualComponent instanceof SceneSupportUserBlock)) continue;
                                    SceneSupportUserBlock sceneSupportUserBlock = (SceneSupportUserBlock)((Object)abstractVisualComponent);
                                    sceneSupportUserBlock.getUserBlock().resetAvatar();
                                }
                            }
                            this.contextHelper.runInFxThread(() -> this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.uploadasset.success.header"), this.application.getTranslation("runtime.overlay.uploadasset.success.description")));
                        }
                        catch (IOException | URISyntaxException exception) {
                            this.errorHandle(exception);
                        }
                    } else {
                        try (InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream((byte[])httpResponse.body()));){
                            UploadError uploadError = Launcher.gsonManager.gson.fromJson((Reader)inputStreamReader, UploadError.class);
                            this.errorHandle(new RequestException(uploadError.error));
                        }
                        catch (Exception exception) {
                            this.errorHandle(exception);
                        }
                    }
                })).exceptionally(throwable -> {
                    this.errorHandle((Throwable)throwable);
                    return null;
                });
            }
            catch (Throwable throwable2) {
                this.errorHandle(throwable2);
            }
        }, this::errorHandle, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {}));
    }

    @Override
    public void reset() {
    }

    public static final class AssetOptions {
        @LauncherNetworkAPI
        private final boolean modelSlim;

        public AssetOptions(boolean bl) {
            this.modelSlim = bl;
        }

        public boolean modelSlim() {
            return this.modelSlim;
        }
    }

    public record UserTexture(@LauncherNetworkAPI String url, @LauncherNetworkAPI String digest, @LauncherNetworkAPI Map<String, String> metadata) {
        Texture toLauncherTexture() {
            return new Texture(this.url, SecurityHelper.fromHex(this.digest), this.metadata);
        }
    }

    public record UploadError(@LauncherNetworkAPI String error) {
    }
}

