/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.overlays;

import javafx.scene.Node;
import javafx.scene.image.Image;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.gui.utils.JavaFxUtils;
import pro.gravit.utils.helper.LogHelper;

public class WelcomeOverlay
extends AbstractOverlay {
    private Image originalImage;

    public WelcomeOverlay(JavaFXApplication javaFXApplication) {
        super("overlay/welcome/welcome.fxml", javaFXApplication);
    }

    @Override
    public String getName() {
        return "welcome";
    }

    @Override
    protected void doInit() {
        this.reset();
    }

    @Override
    public void reset() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#playerName").ifPresent(label -> label.setText(this.application.authService.getUsername()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#playerHead").ifPresent(imageView -> {
            try {
                JavaFxUtils.setStaticRadius(imageView, 8.0);
                Image image = this.application.skinManager.getScaledFxSkinHead(this.application.authService.getUsername(), (int)imageView.getFitWidth(), (int)imageView.getFitHeight());
                if (image != null) {
                    if (this.originalImage == null) {
                        this.originalImage = imageView.getImage();
                    }
                    imageView.setImage(image);
                } else if (this.originalImage != null) {
                    imageView.setImage(this.originalImage);
                }
            }
            catch (Throwable throwable) {
                LogHelper.warning("Skin head error");
            }
        });
    }
}

