/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.debug;

import java.util.Map;
import javafx.scene.control.TextArea;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.service.LaunchService;

public class ProcessLogOutput
implements LaunchService.ClientInstance.ProcessListener {
    static final long MAX_LENGTH = 262144L;
    static final int REMOVE_LENGTH = 16384;
    private final TextArea output;
    private final Object syncObject = new Object();
    private String appendString = "";
    private boolean isOutputRunned;

    public ProcessLogOutput(TextArea textArea) {
        this.output = textArea;
    }

    public String getText() {
        return this.output.getText();
    }

    public void clear() {
        this.output.clear();
    }

    public void copyToClipboard() {
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(this.getText());
        Clipboard clipboard = Clipboard.getSystemClipboard();
        clipboard.setContent((Map)clipboardContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string) {
        boolean bl = false;
        Object object = this.syncObject;
        synchronized (object) {
            this.appendString = (long)this.appendString.length() > 262144L ? "<logs buffer overflow>\n".concat(string) : this.appendString.concat(string);
            if (!this.isOutputRunned) {
                bl = true;
                this.isOutputRunned = true;
            }
        }
        if (bl) {
            ContextHelper.runInFxThreadStatic(() -> {
                Object object = this.syncObject;
                synchronized (object) {
                    if ((long)this.output.lengthProperty().get() > 262144L) {
                        this.output.deleteText(0, 16384);
                    }
                    this.output.appendText(this.appendString);
                    this.appendString = "";
                    this.isOutputRunned = false;
                }
            });
        }
    }

    @Override
    public void onNext(byte[] byArray, int n, int n2) {
        this.append(new String(byArray, n, n2));
    }
}

