/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.base.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.base.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.base.request.auth.details.AuthTotpDetails;
import pro.gravit.launcher.base.request.auth.details.AuthWebViewDetails;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.base.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.LoginAndPasswordAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.LoginOnlyAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.TotpAuthMethod;
import pro.gravit.launcher.gui.scenes.login.methods.WebAuthMethod;
import pro.gravit.utils.helper.LogHelper;

public class AuthFlow {
    public Map<Class<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>, AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>> authMethods = new HashMap<Class<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>, AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>>(8);
    private final LoginScene.LoginSceneAccessor accessor;
    private final List<Integer> authFlow = new ArrayList<Integer>();
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;
    private volatile AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> authMethodOnShow;
    private final Consumer<SuccessAuth> onSuccessAuth;
    public boolean isLoginStarted;

    public AuthFlow(LoginScene.LoginSceneAccessor loginSceneAccessor, Consumer<SuccessAuth> consumer) {
        this.accessor = loginSceneAccessor;
        this.onSuccessAuth = consumer;
        this.authMethods.put(AuthPasswordDetails.class, new LoginAndPasswordAuthMethod(loginSceneAccessor));
        this.authMethods.put(AuthWebViewDetails.class, new WebAuthMethod(loginSceneAccessor));
        this.authMethods.put(AuthTotpDetails.class, new TotpAuthMethod(loginSceneAccessor));
        this.authMethods.put(AuthLoginOnlyDetails.class, new LoginOnlyAuthMethod(loginSceneAccessor));
    }

    public void init(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        this.authAvailability = authAvailability;
        this.reset();
    }

    public void reset() {
        this.authFlow.clear();
        this.authFlow.add(0);
        if (this.authMethodOnShow != null) {
            this.authMethodOnShow.onUserCancel();
        }
        if (!this.accessor.isEmptyContent()) {
            this.accessor.clearContent();
            this.accessor.setState(LoginAuthButtonComponent.AuthButtonState.ACTIVE);
        }
        if (this.authMethodOnShow != null && !this.authMethodOnShow.isOverlay()) {
            this.loginWithGui();
        }
        this.authMethodOnShow = null;
        for (AbstractAuthMethod<? extends GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> abstractAuthMethod : this.authMethods.values()) {
            abstractAuthMethod.reset();
        }
    }

    private CompletableFuture<LoginAndPasswordResult> tryLogin(String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
        CompletionStage<LoginAndPasswordResult> completionStage = null;
        if (authPasswordInterface != null) {
            completionStage = new CompletableFuture<LoginAndPasswordResult>();
            ((CompletableFuture)completionStage).complete(new LoginAndPasswordResult(string, authPasswordInterface));
        }
        for (int n : this.authFlow) {
            GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails authAvailabilityDetails = this.authAvailability.details.get(n);
            AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> abstractAuthMethod = this.detailsToMethod(authAvailabilityDetails);
            if (completionStage == null) {
                completionStage = ((CompletableFuture)((CompletableFuture)abstractAuthMethod.show(authAvailabilityDetails).thenCompose(void_ -> {
                    this.authMethodOnShow = abstractAuthMethod;
                    return CompletableFuture.completedFuture(void_);
                })).thenCompose(void_ -> abstractAuthMethod.auth(authAvailabilityDetails))).thenCompose(loginAndPasswordResult -> {
                    this.authMethodOnShow = null;
                    return CompletableFuture.completedFuture(loginAndPasswordResult);
                });
            } else {
                completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> abstractAuthMethod.show(authAvailabilityDetails).thenApply(void_ -> loginAndPasswordResult));
                completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> {
                    this.authMethodOnShow = abstractAuthMethod;
                    return CompletableFuture.completedFuture(loginAndPasswordResult);
                });
                completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> abstractAuthMethod.auth(authAvailabilityDetails).thenApply(loginAndPasswordResult2 -> {
                    AuthRequest.AuthPasswordInterface authPasswordInterface;
                    AuthRequest.AuthPasswordInterface authPasswordInterface2;
                    String string = null;
                    if (loginAndPasswordResult.login != null) {
                        string = loginAndPasswordResult.login;
                    }
                    if (loginAndPasswordResult2.login != null) {
                        string = loginAndPasswordResult2.login;
                    }
                    if ((authPasswordInterface2 = loginAndPasswordResult.password) instanceof AuthMultiPassword) {
                        AuthMultiPassword authMultiPassword = (AuthMultiPassword)authPasswordInterface2;
                        authPasswordInterface = loginAndPasswordResult.password;
                        authMultiPassword.list.add(loginAndPasswordResult2.password);
                    } else {
                        authPasswordInterface2 = loginAndPasswordResult.password;
                        if (authPasswordInterface2 instanceof Auth2FAPassword) {
                            Auth2FAPassword auth2FAPassword = (Auth2FAPassword)authPasswordInterface2;
                            authPasswordInterface = new AuthMultiPassword();
                            ((AuthMultiPassword)authPasswordInterface).list = new ArrayList<AuthRequest.AuthPasswordInterface>();
                            ((AuthMultiPassword)authPasswordInterface).list.add(auth2FAPassword.firstPassword);
                            ((AuthMultiPassword)authPasswordInterface).list.add(auth2FAPassword.secondPassword);
                            ((AuthMultiPassword)authPasswordInterface).list.add(loginAndPasswordResult2.password);
                        } else {
                            authPasswordInterface = new Auth2FAPassword();
                            ((Auth2FAPassword)authPasswordInterface).firstPassword = loginAndPasswordResult.password;
                            ((Auth2FAPassword)authPasswordInterface).secondPassword = loginAndPasswordResult2.password;
                        }
                    }
                    return new LoginAndPasswordResult(string, authPasswordInterface);
                }));
                completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> {
                    this.authMethodOnShow = null;
                    return CompletableFuture.completedFuture(loginAndPasswordResult);
                });
            }
            completionStage = ((CompletableFuture)completionStage).thenCompose(loginAndPasswordResult -> abstractAuthMethod.hide().thenApply(void_ -> loginAndPasswordResult));
        }
        return completionStage;
    }

    public AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getAuthMethodOnShow() {
        return this.authMethodOnShow;
    }

    private void start(CompletableFuture<SuccessAuth> completableFuture, String string, AuthRequest.AuthPasswordInterface authPasswordInterface) {
        CompletableFuture<LoginAndPasswordResult> completableFuture2 = this.tryLogin(string, authPasswordInterface);
        ((CompletableFuture)completableFuture2.thenAccept(loginAndPasswordResult -> this.login(loginAndPasswordResult.login, loginAndPasswordResult.password, this.authAvailability, completableFuture))).exceptionally(throwable -> {
            throwable = throwable.getCause();
            this.reset();
            this.isLoginStarted = false;
            if (throwable instanceof AbstractAuthMethod.UserAuthCanceledException) {
                return null;
            }
            this.accessor.errorHandle((Throwable)throwable);
            return null;
        });
    }

    private CompletableFuture<SuccessAuth> start() {
        CompletableFuture<SuccessAuth> completableFuture = new CompletableFuture<SuccessAuth>();
        this.start(completableFuture, null, null);
        return completableFuture;
    }

    private void login(String string, AuthRequest.AuthPasswordInterface authPasswordInterface, GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability, CompletableFuture<SuccessAuth> completableFuture) {
        this.isLoginStarted = true;
        JavaFXApplication javaFXApplication = this.accessor.getApplication();
        LogHelper.dev("Auth with %s password ***** authId %s", string, authAvailability);
        AuthRequest authRequest = javaFXApplication.authService.makeAuthRequest(string, authPasswordInterface, authAvailability.name);
        this.accessor.processing(authRequest, javaFXApplication.getTranslation("runtime.overlay.processing.text.auth"), authRequestEvent -> completableFuture.complete(new SuccessAuth((AuthRequestEvent)authRequestEvent, string, authPasswordInterface)), string2 -> {
            if (string2.equals("auth.invalidtoken")) {
                javaFXApplication.runtimeSettings.oauthAccessToken = null;
                javaFXApplication.runtimeSettings.oauthRefreshToken = null;
                completableFuture.completeExceptionally(new RequestException((String)string2));
            } else if (string2.equals("auth.require2fa")) {
                this.authFlow.clear();
                this.authFlow.add(1);
                this.accessor.runInFxThread(() -> this.start(completableFuture, string, authPasswordInterface));
            } else if (string2.startsWith("auth.require.factor.")) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (String string3 : string2.substring("auth.require.factor.".length() + 1).split("\\.")) {
                    arrayList.add(Integer.parseInt(string3));
                }
                this.authFlow.clear();
                this.authFlow.addAll(arrayList);
                this.accessor.runInFxThread(() -> this.start(completableFuture, string, authPasswordInterface));
            } else {
                this.authFlow.clear();
                this.authFlow.add(0);
                this.accessor.errorHandle(new RequestException((String)string2));
            }
        });
    }

    void loginWithGui() {
        this.accessor.setState(LoginAuthButtonComponent.AuthButtonState.UNACTIVE);
        AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> abstractAuthMethod = this.getAuthMethodOnShow();
        if (abstractAuthMethod != null) {
            abstractAuthMethod.onAuthClicked();
            return;
        }
        if (this.tryOAuthLogin()) {
            return;
        }
        this.start().thenAccept(successAuth -> {
            if (this.onSuccessAuth != null) {
                this.onSuccessAuth.accept((SuccessAuth)successAuth);
            }
        });
    }

    private boolean tryOAuthLogin() {
        JavaFXApplication javaFXApplication = this.accessor.getApplication();
        if (javaFXApplication.runtimeSettings.lastAuth != null && this.authAvailability.name.equals(javaFXApplication.runtimeSettings.lastAuth.name) && javaFXApplication.runtimeSettings.oauthAccessToken != null) {
            if (javaFXApplication.runtimeSettings.oauthExpire != 0L && javaFXApplication.runtimeSettings.oauthExpire < System.currentTimeMillis()) {
                this.refreshToken();
                return true;
            }
            Request.setOAuth(this.authAvailability.name, new AuthRequestEvent.OAuthRequestEvent(javaFXApplication.runtimeSettings.oauthAccessToken, javaFXApplication.runtimeSettings.oauthRefreshToken, javaFXApplication.runtimeSettings.oauthExpire), javaFXApplication.runtimeSettings.oauthExpire);
            AuthOAuthPassword authOAuthPassword = new AuthOAuthPassword(javaFXApplication.runtimeSettings.oauthAccessToken);
            LogHelper.info("Login with OAuth AccessToken");
            this.loginWithOAuth(authOAuthPassword, this.authAvailability, true);
            return true;
        }
        return false;
    }

    private void refreshToken() {
        JavaFXApplication javaFXApplication = this.accessor.getApplication();
        RefreshTokenRequest refreshTokenRequest = new RefreshTokenRequest(this.authAvailability.name, javaFXApplication.runtimeSettings.oauthRefreshToken);
        this.accessor.processing(refreshTokenRequest, javaFXApplication.getTranslation("runtime.overlay.processing.text.auth"), refreshTokenRequestEvent -> {
            javaFXApplication.runtimeSettings.oauthAccessToken = refreshTokenRequestEvent.oauth.accessToken;
            javaFXApplication.runtimeSettings.oauthRefreshToken = refreshTokenRequestEvent.oauth.refreshToken;
            javaFXApplication.runtimeSettings.oauthExpire = refreshTokenRequestEvent.oauth.expire == 0L ? 0L : System.currentTimeMillis() + refreshTokenRequestEvent.oauth.expire;
            Request.setOAuth(this.authAvailability.name, refreshTokenRequestEvent.oauth);
            AuthOAuthPassword authOAuthPassword = new AuthOAuthPassword(javaFXApplication.runtimeSettings.oauthAccessToken);
            LogHelper.info("Login with OAuth AccessToken");
            this.loginWithOAuth(authOAuthPassword, this.authAvailability, false);
        }, string -> {
            javaFXApplication.runtimeSettings.oauthAccessToken = null;
            javaFXApplication.runtimeSettings.oauthRefreshToken = null;
            this.accessor.runInFxThread(this::loginWithGui);
        });
    }

    private void loginWithOAuth(AuthOAuthPassword authOAuthPassword, GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability, boolean bl) {
        JavaFXApplication javaFXApplication = this.accessor.getApplication();
        AuthRequest authRequest = javaFXApplication.authService.makeAuthRequest(null, authOAuthPassword, authAvailability.name);
        this.accessor.processing(authRequest, javaFXApplication.getTranslation("runtime.overlay.processing.text.auth"), authRequestEvent -> this.accessor.runInFxThread(() -> this.onSuccessAuth.accept(new SuccessAuth((AuthRequestEvent)authRequestEvent, null, null))), string -> {
            if (bl && string.equals("auth.expiretoken")) {
                this.refreshToken();
                return;
            }
            if (string.equals("auth.invalidtoken")) {
                javaFXApplication.runtimeSettings.oauthAccessToken = null;
                javaFXApplication.runtimeSettings.oauthRefreshToken = null;
                this.accessor.runInFxThread(this::loginWithGui);
            } else {
                this.accessor.errorHandle(new RequestException((String)string));
            }
        });
    }

    private AbstractAuthMethod<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> detailsToMethod(GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails authAvailabilityDetails) {
        return this.authMethods.get(authAvailabilityDetails.getClass());
    }

    public void prepare() {
        this.authMethods.forEach((clazz, abstractAuthMethod) -> abstractAuthMethod.prepare());
    }

    public record LoginAndPasswordResult(String login, AuthRequest.AuthPasswordInterface password) {
    }

    public record SuccessAuth(AuthRequestEvent requestEvent, String recentLogin, AuthRequest.AuthPasswordInterface recentPassword) {
    }
}

