/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import pro.gravit.launcher.gui.JavaFXApplication;

public class LoginAuthButtonComponent {
    private final JavaFXApplication application;
    private final Button button;
    private AuthButtonState state = AuthButtonState.UNACTIVE;
    private String originalText;

    public LoginAuthButtonComponent(Button button, JavaFXApplication javaFXApplication, EventHandler<ActionEvent> eventHandler) {
        this.application = javaFXApplication;
        this.button = button;
        this.button.setOnAction(eventHandler);
        this.originalText = this.button.getText();
    }

    public AuthButtonState getState() {
        return this.state;
    }

    public void setState(AuthButtonState authButtonState) {
        if (authButtonState == null) {
            throw new NullPointerException("State can't be null");
        }
        if (authButtonState == this.state) {
            return;
        }
        if (this.state != null) {
            this.button.getStyleClass().remove((Object)this.state.getStyleClass());
        }
        this.button.getStyleClass().add((Object)authButtonState.getStyleClass());
        if (authButtonState == AuthButtonState.ERROR) {
            this.button.setText("ERROR");
        } else if (this.state == AuthButtonState.ERROR) {
            this.button.setText(this.originalText);
        }
        this.state = authButtonState;
    }

    public String getText() {
        return this.button.getText();
    }

    public void setText(String string) {
        this.button.setText(string);
        this.originalText = string;
    }

    public static enum AuthButtonState {
        ACTIVE("activeButton"),
        UNACTIVE("unactiveButton"),
        ERROR("errorButton");

        private final String styleClass;

        public String getStyleClass() {
            return this.styleClass;
        }

        private AuthButtonState(String string2) {
            this.styleClass = string2;
        }
    }
}

