/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login;

import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.profiles.Texture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.base.request.auth.details.AuthPasswordDetails;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.base.request.update.LauncherRequest;
import pro.gravit.launcher.base.request.update.ProfilesRequest;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.StdJavaRuntimeProvider;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.runtime.LauncherEngine;
import pro.gravit.launcher.runtime.utils.LauncherUpdater;
import pro.gravit.utils.helper.LogHelper;

public class LoginScene
extends AbstractScene {
    private List<GetAvailabilityAuthRequestEvent.AuthAvailability> auth;
    private CheckBox savePasswordCheckBox;
    private CheckBox autoenter;
    private Pane content;
    private AbstractVisualComponent contentComponent;
    private LoginAuthButtonComponent authButton;
    private ComboBox<GetAvailabilityAuthRequestEvent.AuthAvailability> authList;
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;
    private final AuthFlow authFlow;

    public LoginScene(JavaFXApplication javaFXApplication) {
        super("scenes/login/login.fxml", javaFXApplication);
        LoginSceneAccessor loginSceneAccessor = new LoginSceneAccessor();
        this.authFlow = new AuthFlow(loginSceneAccessor, this::onSuccessLogin);
    }

    @Override
    public void doInit() {
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.globalSettingsScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.authButton = new LoginAuthButtonComponent((Button)LookupHelper.lookup((Node)this.layout, "#authButton"), this.application, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.contextHelper.runCallback(this.authFlow::loginWithGui)));
        this.savePasswordCheckBox = (CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword");
        if (this.application.runtimeSettings.password != null || this.application.runtimeSettings.oauthAccessToken != null) {
            ((CheckBox)LookupHelper.lookup((Node)this.layout, "#savePassword")).setSelected(true);
        }
        this.autoenter = (CheckBox)LookupHelper.lookup((Node)this.layout, "#autoenter");
        this.autoenter.setSelected(this.application.runtimeSettings.autoAuth);
        this.autoenter.setOnAction(actionEvent -> {
            this.application.runtimeSettings.autoAuth = this.autoenter.isSelected();
        });
        this.content = (Pane)LookupHelper.lookup((Node)this.layout, "#content");
        if (this.application.guiModuleConfig.createAccountURL != null) {
            ((Text)LookupHelper.lookup((Node)this.header, "#createAccount")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.createAccountURL));
        }
        if (this.application.guiModuleConfig.forgotPassURL != null) {
            ((Text)LookupHelper.lookup((Node)this.header, "#forgotPass")).setOnMouseClicked(mouseEvent -> this.application.openURL(this.application.guiModuleConfig.forgotPassURL));
        }
        this.authList = (ComboBox)LookupHelper.lookup((Node)this.layout, "#authList");
        this.authList.setConverter((StringConverter)new AuthAvailabilityStringConverter());
        this.authList.setOnAction(actionEvent -> this.changeAuthAvailability((GetAvailabilityAuthRequestEvent.AuthAvailability)this.authList.getSelectionModel().getSelectedItem()));
        this.authFlow.prepare();
    }

    @Override
    protected void doPostInit() {
        if (!this.application.isDebugMode()) {
            this.launcherRequest();
        } else {
            this.getAvailabilityAuth();
        }
    }

    private void launcherRequest() {
        LauncherRequest launcherRequest = new LauncherRequest();
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.launcher"), launcherRequest, launcherRequestEvent -> {
            if (launcherRequestEvent.needUpdate) {
                try {
                    LogHelper.debug("Start update processing");
                    this.disable();
                    StdJavaRuntimeProvider.updatePath = LauncherUpdater.prepareUpdate(new URI(launcherRequestEvent.url).toURL());
                    LogHelper.debug("Exit with Platform.exit");
                    Platform.exit();
                    return;
                }
                catch (Throwable throwable) {
                    this.contextHelper.runInFxThread(() -> this.errorHandle(throwable));
                    try {
                        Thread.sleep(1500L);
                        LauncherEngine.modulesManager.invokeEvent(new ClientExitPhase(0));
                        Platform.exit();
                    }
                    catch (Throwable throwable2) {
                        LauncherEngine.exitLauncher(0);
                    }
                }
            }
            LogHelper.dev("Launcher update processed");
            this.getAvailabilityAuth();
        }, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> LauncherEngine.exitLauncher(0)));
    }

    private void getAvailabilityAuth() {
        GetAvailabilityAuthRequest getAvailabilityAuthRequest = new GetAvailabilityAuthRequest();
        this.processing(getAvailabilityAuthRequest, this.application.getTranslation("runtime.overlay.processing.text.authAvailability"), getAvailabilityAuthRequestEvent -> this.contextHelper.runInFxThread(() -> {
            this.auth = getAvailabilityAuthRequestEvent.list;
            this.authList.setVisible(getAvailabilityAuthRequestEvent.list.size() != 1);
            this.authList.setManaged(getAvailabilityAuthRequestEvent.list.size() != 1);
            for (GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability : getAvailabilityAuthRequestEvent.list) {
                if (!authAvailability.visible) continue;
                if (this.application.runtimeSettings.lastAuth == null) {
                    if (authAvailability.name.equals("std") || this.authAvailability == null) {
                        this.changeAuthAvailability(authAvailability);
                    }
                } else if (authAvailability.name.equals(this.application.runtimeSettings.lastAuth.name)) {
                    this.changeAuthAvailability(authAvailability);
                }
                if (!authAvailability.visible) continue;
                this.addAuthAvailability(authAvailability);
            }
            if (this.authAvailability == null && !getAvailabilityAuthRequestEvent.list.isEmpty()) {
                this.changeAuthAvailability(getAvailabilityAuthRequestEvent.list.get(0));
            }
            this.runAutoAuth();
        }), null);
    }

    private void runAutoAuth() {
        block3: {
            block2: {
                if (this.application.guiModuleConfig.autoAuth) break block2;
                if (!this.application.runtimeSettings.autoAuth) break block3;
            }
            this.contextHelper.runInFxThread(this.authFlow::loginWithGui);
        }
    }

    public void changeAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        boolean bl = this.authAvailability != authAvailability;
        this.authAvailability = authAvailability;
        this.application.authService.setAuthAvailability(authAvailability);
        ((SingleSelectionModel)this.authList.selectionModelProperty().get()).select((Object)authAvailability);
        this.authFlow.init(authAvailability);
        LogHelper.info("Selected auth: %s", authAvailability.name);
    }

    public void addAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        this.authList.getItems().add((Object)authAvailability);
        LogHelper.info("Added %s: %s", authAvailability.name, authAvailability.displayName);
    }

    public <T extends WebSocketEvent> void processing(Request<T> request, String string, Consumer<T> consumer, Consumer<String> consumer2) {
        this.processRequest(string, request, consumer, throwable -> consumer2.accept(throwable.getCause().getMessage()), null);
    }

    @Override
    public void errorHandle(Throwable throwable) {
        super.errorHandle(throwable);
        this.contextHelper.runInFxThread(() -> this.authButton.setState(LoginAuthButtonComponent.AuthButtonState.ERROR));
    }

    @Override
    public void reset() {
        this.authFlow.reset();
    }

    @Override
    public String getName() {
        return "login";
    }

    private boolean checkSavePasswordAvailable(AuthRequest.AuthPasswordInterface authPasswordInterface) {
        if (authPasswordInterface instanceof Auth2FAPassword) {
            return false;
        }
        if (authPasswordInterface instanceof AuthMultiPassword) {
            return false;
        }
        return this.authAvailability != null && this.authAvailability.details != null && !this.authAvailability.details.isEmpty() && this.authAvailability.details.get(0) instanceof AuthPasswordDetails;
    }

    public void onSuccessLogin(AuthFlow.SuccessAuth successAuth) {
        AuthRequestEvent authRequestEvent = successAuth.requestEvent();
        this.application.authService.setAuthResult(this.authAvailability.name, authRequestEvent);
        boolean bl = this.savePasswordCheckBox.isSelected();
        if (bl) {
            this.application.runtimeSettings.login = successAuth.recentLogin();
            if (authRequestEvent.oauth == null) {
                LogHelper.warning("Password not saved");
            } else {
                this.application.runtimeSettings.oauthAccessToken = authRequestEvent.oauth.accessToken;
                this.application.runtimeSettings.oauthRefreshToken = authRequestEvent.oauth.refreshToken;
                this.application.runtimeSettings.oauthExpire = Request.getTokenExpiredTime();
                this.application.runtimeSettings.password = null;
            }
            this.application.runtimeSettings.lastAuth = this.authAvailability;
        }
        if (authRequestEvent.playerProfile != null && authRequestEvent.playerProfile.assets != null) {
            try {
                Texture texture = authRequestEvent.playerProfile.assets.get("SKIN");
                Texture texture2 = authRequestEvent.playerProfile.assets.get("AVATAR");
                if (texture != null || texture2 != null) {
                    this.application.skinManager.addSkinWithAvatar(authRequestEvent.playerProfile.username, texture != null ? new URI(texture.url) : null, texture2 != null ? new URI(texture2.url) : null);
                    this.application.skinManager.getSkin(authRequestEvent.playerProfile.username);
                }
            }
            catch (Exception exception) {
                LogHelper.error(exception);
            }
        }
        this.contextHelper.runInFxThread(() -> {
            if (this.application.gui.welcomeOverlay.isInit()) {
                this.application.gui.welcomeOverlay.reset();
            }
            this.showOverlay(this.application.gui.welcomeOverlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent2 -> this.application.gui.welcomeOverlay.hide(2000.0, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.onGetProfiles()))));
        });
    }

    public void onGetProfiles() {
        this.processing(new ProfilesRequest(), this.application.getTranslation("runtime.overlay.processing.text.profiles"), profilesRequestEvent -> {
            this.application.profilesService.setProfilesResult((ProfilesRequestEvent)profilesRequestEvent);
            this.application.runtimeSettings.profiles = profilesRequestEvent.profiles;
            this.contextHelper.runInFxThread(() -> {
                AbstractScene abstractScene;
                this.application.securityService.startRequest();
                if (this.application.gui.optionsScene != null) {
                    try {
                        this.application.profilesService.loadAll();
                    }
                    catch (Throwable throwable) {
                        this.errorHandle(throwable);
                    }
                }
                if ((abstractScene = this.application.getCurrentScene()) instanceof LoginScene) {
                    LoginScene loginScene = (LoginScene)abstractScene;
                    loginScene.authFlow.isLoginStarted = false;
                }
                this.application.setMainScene(this.application.gui.serverMenuScene);
            });
        }, null);
    }

    public void clearPassword() {
        this.application.runtimeSettings.password = null;
        this.application.runtimeSettings.login = null;
        this.application.runtimeSettings.oauthAccessToken = null;
        this.application.runtimeSettings.oauthRefreshToken = null;
    }

    public AuthFlow getAuthFlow() {
        return this.authFlow;
    }

    public class LoginSceneAccessor
    extends AbstractScene.SceneAccessor {
        public void showContent(AbstractVisualComponent abstractVisualComponent) throws Exception {
            abstractVisualComponent.init();
            abstractVisualComponent.postInit();
            if (LoginScene.this.contentComponent != null) {
                LoginScene.this.content.getChildren().clear();
            }
            LoginScene.this.contentComponent = abstractVisualComponent;
            LoginScene.this.content.getChildren().add((Object)abstractVisualComponent.getLayout());
        }

        public LoginAuthButtonComponent getAuthButton() {
            return LoginScene.this.authButton;
        }

        public void setState(LoginAuthButtonComponent.AuthButtonState authButtonState) {
            LoginScene.this.authButton.setState(authButtonState);
        }

        public boolean isEmptyContent() {
            return LoginScene.this.content.getChildren().isEmpty();
        }

        public void clearContent() {
            LoginScene.this.content.getChildren().clear();
        }

        public <T extends WebSocketEvent> void processing(Request<T> request, String string, Consumer<T> consumer, Consumer<String> consumer2) {
            LoginScene.this.processing(request, string, consumer, consumer2);
        }
    }

    private static class AuthAvailabilityStringConverter
    extends StringConverter<GetAvailabilityAuthRequestEvent.AuthAvailability> {
        private AuthAvailabilityStringConverter() {
        }

        public String toString(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
            return authAvailability == null ? "null" : authAvailability.displayName;
        }

        public GetAvailabilityAuthRequestEvent.AuthAvailability fromString(String string) {
            return null;
        }
    }
}

