/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import pro.gravit.launcher.base.request.auth.details.AuthWebViewDetails;
import pro.gravit.launcher.base.request.auth.password.AuthCodePassword;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.utils.helper.LogHelper;

public class WebAuthMethod
extends AbstractAuthMethod<AuthWebViewDetails> {
    WebAuthOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public WebAuthMethod(LoginScene.LoginSceneAccessor loginSceneAccessor) {
        this.application = loginSceneAccessor.getApplication();
        this.accessor = loginSceneAccessor;
        this.overlay = this.application.gui.registerComponent(WebAuthOverlay.class);
        this.overlay.accessor = loginSceneAccessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthWebViewDetails authWebViewDetails) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        try {
            this.accessor.showOverlay(this.overlay, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        }
        catch (Exception exception) {
            this.accessor.errorHandle(exception);
        }
        return completableFuture;
    }

    @Override
    public CompletableFuture<AuthFlow.LoginAndPasswordResult> auth(AuthWebViewDetails authWebViewDetails) {
        this.overlay.future = new CompletableFuture();
        this.overlay.follow(authWebViewDetails.url, authWebViewDetails.redirectUrl, string -> {
            LogHelper.dev("Redirect uri: %s", string);
            this.overlay.future.complete(new AuthFlow.LoginAndPasswordResult(null, new AuthCodePassword((String)string)));
        });
        return this.overlay.future;
    }

    @Override
    public void onAuthClicked() {
    }

    @Override
    public void onUserCancel() {
    }

    @Override
    public CompletableFuture<Void> hide() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.overlay.hide((EventHandler<ActionEvent>)((EventHandler)actionEvent -> completableFuture.complete(null)));
        return completableFuture;
    }

    @Override
    public boolean isOverlay() {
        return true;
    }

    public static class WebAuthOverlay
    extends AbstractOverlay {
        private WebView webView;
        private LoginScene.LoginSceneAccessor accessor;
        private CompletableFuture<AuthFlow.LoginAndPasswordResult> future;

        public WebAuthOverlay(JavaFXApplication javaFXApplication) {
            super("overlay/webauth/webauth.fxml", javaFXApplication);
        }

        @Override
        public String getName() {
            return "webView";
        }

        public void hide(EventHandler<ActionEvent> eventHandler) {
            this.hide(10.0, eventHandler);
        }

        @Override
        protected void doInit() {
            ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#webview");
            this.webView = new WebView();
            scrollPane.setContent((Node)new VBox(new Node[]{this.webView}));
            ((Button)LookupHelper.lookup((Node)this.layout, "#exit")).setOnAction(actionEvent -> {
                if (this.future != null) {
                    this.future.completeExceptionally(new AbstractAuthMethod.UserAuthCanceledException());
                }
                this.hide(null);
            });
        }

        public void follow(String string, String string4, Consumer<String> consumer) {
            LogHelper.dev("Load url %s", string);
            this.webView.getEngine().setJavaScriptEnabled(true);
            this.webView.getEngine().load(string);
            if (consumer != null) {
                this.webView.getEngine().locationProperty().addListener((observableValue, string2, string3) -> {
                    if (string3 != null) {
                        LogHelper.dev("Location: %s", string3);
                        if (string4 != null) {
                            if (string3.startsWith(string4)) {
                                consumer.accept((String)string3);
                            }
                        } else {
                            consumer.accept((String)string3);
                        }
                    }
                });
            }
        }

        public WebView getWebView() {
            return this.webView;
        }

        @Override
        public void reset() {
        }
    }
}

