/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.options;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.components.ServerButton;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.gui.scenes.options.OptionsTab;

public class OptionsScene
extends AbstractScene
implements SceneSupportUserBlock {
    private OptionsTab optionsTab;
    private UserBlock userBlock;

    public OptionsScene(JavaFXApplication javaFXApplication) {
        super("scenes/options/options.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        this.userBlock = new UserBlock(this.layout, new AbstractScene.SceneAccessor());
        this.optionsTab = new OptionsTab(this.application, (TabPane)LookupHelper.lookup((Node)this.layout, "#tabPane"));
    }

    @Override
    public void reset() {
        Pane pane = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        pane.getChildren().clear();
        ClientProfile clientProfile = this.application.profilesService.getProfile();
        ServerButton serverButton = ServerButton.createServerButton(this.application, clientProfile);
        serverButton.addTo(pane);
        serverButton.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            try {
                this.application.profilesService.setOptionalView(clientProfile, this.optionsTab.getOptionalView());
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        serverButton.enableResetButton(null, (EventHandler<ActionEvent>)((EventHandler)actionEvent -> {
            this.optionsTab.clear();
            this.application.profilesService.setOptionalView(clientProfile, new OptionalView(clientProfile));
            this.optionsTab.addProfileOptionals(this.application.profilesService.getOptionalView());
        }));
        this.optionsTab.clear();
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(button -> button.setOnAction(actionEvent -> {
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.optionsTab.addProfileOptionals(this.application.profilesService.getOptionalView());
        this.userBlock.reset();
    }

    @Override
    public String getName() {
        return "options";
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }
}

