/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.serverinfo;

import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.components.ServerButton;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.gui.service.LaunchService;
import pro.gravit.utils.helper.LogHelper;

public class ServerInfoScene
extends AbstractScene
implements SceneSupportUserBlock {
    private ServerButton serverButton;
    private UserBlock userBlock;

    public ServerInfoScene(JavaFXApplication javaFXApplication) {
        super("scenes/serverinfo/serverinfo.fxml", javaFXApplication);
    }

    @Override
    protected void doInit() {
        this.userBlock = new UserBlock(this.layout, new AbstractScene.SceneAccessor(this));
        ((Button)LookupHelper.lookup((Node)this.layout, "#back")).setOnAction(actionEvent -> {
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#clientSettings")).setOnAction(actionEvent -> {
            try {
                if (this.application.profilesService.getProfile() == null) {
                    return;
                }
                this.switchScene(this.application.gui.optionsScene);
                this.application.gui.optionsScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.settingsScene);
                this.application.gui.settingsScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.reset();
    }

    @Override
    public void reset() {
        ClientProfile clientProfile = this.application.profilesService.getProfile();
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverName").ifPresent(label -> label.setText(clientProfile.getTitle()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverDescriptionPane").ifPresent(scrollPane -> {
            Label label = (Label)scrollPane.getContent();
            label.setText(clientProfile.getInfo());
        });
        Pane pane = (Pane)LookupHelper.lookup((Node)this.layout, "#serverButton");
        pane.getChildren().clear();
        this.serverButton = ServerButton.createServerButton(this.application, clientProfile);
        this.serverButton.addTo(pane);
        this.serverButton.enableSaveButton(this.application.getTranslation("runtime.scenes.serverinfo.serverButton.game"), (EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.runClient()));
        this.userBlock.reset();
    }

    private void runClient() {
        ((CompletableFuture)this.application.launchService.launchClient().thenAccept(clientInstance -> {
            if (this.application.runtimeSettings.globalSettings.debugAllClients || clientInstance.getSettings().debug) {
                this.contextHelper.runInFxThread(() -> {
                    try {
                        this.switchScene(this.application.gui.debugScene);
                        this.application.gui.debugScene.onClientInstance((LaunchService.ClientInstance)clientInstance);
                    }
                    catch (Exception exception) {
                        this.errorHandle(exception);
                    }
                });
            } else {
                clientInstance.start();
                ((CompletableFuture)clientInstance.getOnWriteParamsFuture().thenAccept(void_ -> {
                    LogHelper.info("Params write successful. Exit...");
                    Platform.exit();
                })).exceptionally(throwable -> {
                    this.contextHelper.runInFxThread(() -> this.errorHandle((Throwable)throwable));
                    return null;
                });
            }
        })).exceptionally(throwable -> {
            this.contextHelper.runInFxThread(() -> this.errorHandle((Throwable)throwable));
            return null;
        });
    }

    @Override
    public String getName() {
        return "serverinfo";
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }
}

