/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.servermenu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.components.ServerButton;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.runtime.client.ServerPinger;
import pro.gravit.utils.helper.CommonHelper;

public class ServerMenuScene
extends AbstractScene
implements SceneSupportUserBlock {
    private List<ClientProfile> lastProfiles;
    private UserBlock userBlock;

    public ServerMenuScene(JavaFXApplication javaFXApplication) {
        super("scenes/servermenu/servermenu.fxml", javaFXApplication);
    }

    @Override
    public void doInit() {
        this.userBlock = new UserBlock(this.layout, new AbstractScene.SceneAccessor());
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#settings")).setOnAction(actionEvent -> {
            try {
                this.switchScene(this.application.gui.globalSettingsScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        scrollPane.setOnScroll(scrollEvent -> {
            double d = scrollPane.getWidth();
            double d2 = d * 0.15 / (scrollPane.getContent().getBoundsInLocal().getWidth() - d) * Math.signum(scrollEvent.getDeltaY());
            scrollPane.setHvalue(scrollPane.getHvalue() - d2);
        });
        this.reset();
        this.isResetOnShow = true;
    }

    @Override
    public void reset() {
        ClientProfile clientProfile2;
        if (this.lastProfiles == this.application.profilesService.getProfiles()) {
            return;
        }
        this.lastProfiles = this.application.profilesService.getProfiles();
        LinkedHashMap<ClientProfile, ServerButtonCache> linkedHashMap = new LinkedHashMap<ClientProfile, ServerButtonCache>();
        ArrayList<ClientProfile> arrayList = new ArrayList<ClientProfile>(this.lastProfiles);
        arrayList.sort(Comparator.comparingInt(ClientProfile::getSortIndex).thenComparing(ClientProfile::getTitle));
        int n = 0;
        for (ClientProfile clientProfile2 : arrayList) {
            ServerButtonCache serverButtonCache = new ServerButtonCache();
            serverButtonCache.serverButton = ServerButton.createServerButton(this.application, clientProfile2);
            serverButtonCache.position = n++;
            linkedHashMap.put(clientProfile2, serverButtonCache);
        }
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        clientProfile2 = (HBox)scrollPane.getContent();
        clientProfile2.setSpacing(20.0);
        clientProfile2.getChildren().clear();
        this.application.pingService.clear();
        linkedHashMap.forEach((arg_0, arg_1) -> this.lambda$reset$3((HBox)clientProfile2, arg_0, arg_1));
        CommonHelper.newThread("ServerPinger", true, () -> {
            for (ClientProfile clientProfile : this.lastProfiles) {
                for (ClientProfile.ServerProfile serverProfile : clientProfile.getServers()) {
                    if (!serverProfile.socketPing || serverProfile.serverAddress == null) continue;
                    try {
                        ServerPinger serverPinger = new ServerPinger(serverProfile, clientProfile.getVersion());
                        ServerPinger.Result result = serverPinger.ping();
                        this.contextHelper.runInFxThread(() -> this.application.pingService.addReport(serverProfile.name, result));
                    }
                    catch (IOException iOException) {}
                }
            }
        }).start();
        this.userBlock.reset();
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }

    @Override
    public String getName() {
        return "serverMenu";
    }

    private void changeServer(ClientProfile clientProfile) {
        this.application.profilesService.setProfile(clientProfile);
        this.application.runtimeSettings.lastProfile = clientProfile.getUUID();
    }

    private /* synthetic */ void lambda$reset$3(HBox hBox, ClientProfile clientProfile, ServerButtonCache serverButtonCache) {
        EventHandler eventHandler = mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            this.changeServer(clientProfile);
            try {
                this.switchScene(this.application.gui.serverInfoScene);
                this.application.gui.serverInfoScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        };
        serverButtonCache.serverButton.addTo((Pane)hBox, serverButtonCache.position);
        serverButtonCache.serverButton.setOnMouseClicked((EventHandler<? super MouseEvent>)eventHandler);
    }

    static class ServerButtonCache {
        public ServerButton serverButton;
        public int position;

        ServerButtonCache() {
        }
    }
}

