/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Hyperlink;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.settings.BaseSettingsScene;
import pro.gravit.launcher.gui.scenes.settings.components.LanguageSelectorComponent;
import pro.gravit.launcher.gui.scenes.settings.components.ThemeSelectorComponent;
import pro.gravit.launcher.gui.stage.ConsoleStage;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class GlobalSettingsScene
extends BaseSettingsScene {
    private ThemeSelectorComponent themeSelector;
    private LanguageSelectorComponent languageSelectorComponent;

    public GlobalSettingsScene(JavaFXApplication javaFXApplication) {
        super("scenes/settings/globalsettings.fxml", javaFXApplication);
    }

    @Override
    public String getName() {
        return "globalsettings";
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.themeSelector = new ThemeSelectorComponent(this.application, this.componentList);
        this.languageSelectorComponent = new LanguageSelectorComponent(this.application, this.componentList);
        ((ButtonBase)LookupHelper.lookup((Node)this.header, "#controls", "#console")).setOnAction(actionEvent -> {
            try {
                if (this.application.gui.consoleStage == null) {
                    this.application.gui.consoleStage = new ConsoleStage(this.application);
                }
                if (this.application.gui.consoleStage.isNullScene()) {
                    this.application.gui.consoleStage.setScene(this.application.gui.consoleScene, true);
                }
                this.application.gui.consoleStage.show();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        Hyperlink hyperlink = (Hyperlink)LookupHelper.lookup((Node)this.componentList, "#folder", "#path");
        String string = DirBridge.dirUpdates.toAbsolutePath().toString();
        hyperlink.setText(string);
        if (hyperlink.getTooltip() != null) {
            hyperlink.getTooltip().setText(string);
        }
        hyperlink.setOnAction(actionEvent -> this.application.openURL(string));
        ((ButtonBase)LookupHelper.lookup((Node)this.componentList, "#changeDir")).setOnAction(actionEvent -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle(this.application.getTranslation("runtime.scenes.settings.dirTitle"));
            directoryChooser.setInitialDirectory(DirBridge.dir.toFile());
            File file = directoryChooser.showDialog((Window)this.application.getMainStage().getStage());
            if (file == null) {
                return;
            }
            Path path = file.toPath().toAbsolutePath();
            try {
                DirBridge.move(path);
            }
            catch (IOException iOException) {
                this.errorHandle(iOException);
            }
            this.application.runtimeSettings.updatesDirPath = path.toString();
            this.application.runtimeSettings.updatesDir = path;
            String string = DirBridge.dirUpdates.toString();
            DirBridge.dirUpdates = path;
            for (ClientProfile clientProfile : this.application.profilesService.getProfiles()) {
                RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings(clientProfile);
                if (profileSettings.javaPath == null || !profileSettings.javaPath.startsWith(string)) continue;
                profileSettings.javaPath = path.toString().concat(profileSettings.javaPath.substring(string.length()));
            }
            this.application.javaService.update();
            hyperlink.setText(this.application.runtimeSettings.updatesDirPath);
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#deleteDir").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.deletedir.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.description"), () -> {
            LogHelper.debug("Delete dir: %s", DirBridge.dirUpdates);
            try {
                IOHelper.deleteDir(DirBridge.dirUpdates, false);
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.scenes.settings.deletedir.fail.header"), this.application.getTranslation("runtime.scenes.settings.deletedir.fail.description"));
            }
        }, () -> {}, true)));
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(buttonBase -> buttonBase.setOnAction(actionEvent -> {
            try {
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        RuntimeSettings.GlobalSettings globalSettings = this.application.runtimeSettings.globalSettings;
        this.add("PrismVSync", globalSettings.prismVSync, bl -> {
            globalSettings.prismVSync = bl;
        }, false);
        this.add("DebugAllClients", globalSettings.debugAllClients, bl -> {
            globalSettings.debugAllClients = bl;
        }, false);
    }
}

