/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings.components;

import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.stage.PopupWindow;
import javafx.util.Callback;
import javafx.util.StringConverter;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.service.JavaService;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaSelectorComponent {
    private final ComboBox<JavaHelper.JavaVersion> comboBox;
    private final RuntimeSettings.ProfileSettingsView profileSettings;
    private final ClientProfile profile;
    private final JavaService javaService;

    public JavaSelectorComponent(JavaService javaService, Pane pane, RuntimeSettings.ProfileSettingsView profileSettingsView, ClientProfile clientProfile) {
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)pane, "#javaCombo");
        this.profile = clientProfile;
        this.comboBox.getItems().clear();
        this.profileSettings = profileSettingsView;
        this.javaService = javaService;
        this.comboBox.setConverter((StringConverter)new JavaVersionConverter(clientProfile));
        this.comboBox.setCellFactory((Callback)new JavaVersionCellFactory((StringConverter<JavaHelper.JavaVersion>)this.comboBox.getConverter()));
        this.reset();
    }

    public void reset() {
        boolean bl = true;
        Object object = this.javaService.javaVersions.iterator();
        while (object.hasNext()) {
            JavaHelper.JavaVersion javaVersion = object.next();
            if (this.javaService.isIncompatibleJava(javaVersion, this.profile)) continue;
            this.comboBox.getItems().add((Object)javaVersion);
            if (this.profileSettings.javaPath == null || !this.profileSettings.javaPath.equals(javaVersion.jvmDir.toString())) continue;
            this.comboBox.setValue((Object)javaVersion);
            bl = false;
        }
        if (this.comboBox.getTooltip() != null) {
            this.comboBox.getTooltip().setText(this.profileSettings.javaPath);
        }
        if (bl && (object = this.javaService.getRecommendJavaVersion(this.profile)) != null) {
            LogHelper.warning("Selected Java Version not found. Using %s", ((JavaHelper.JavaVersion)object).jvmDir.toAbsolutePath().toString());
            this.comboBox.getSelectionModel().select(object);
            this.profileSettings.javaPath = ((JavaHelper.JavaVersion)object).jvmDir.toAbsolutePath().toString();
        }
        this.comboBox.setOnAction(actionEvent -> {
            JavaHelper.JavaVersion javaVersion = (JavaHelper.JavaVersion)this.comboBox.getValue();
            if (javaVersion == null) {
                return;
            }
            String string = javaVersion.jvmDir.toAbsolutePath().toString();
            if (this.comboBox.getTooltip() != null) {
                this.comboBox.getTooltip().setText(string);
            }
            LogHelper.info("Select Java %s", string);
            this.profileSettings.javaPath = string;
        });
    }

    public String getPath() {
        return ((JavaHelper.JavaVersion)this.comboBox.getValue()).jvmDir.toAbsolutePath().toString();
    }

    private static class JavaVersionConverter
    extends StringConverter<JavaHelper.JavaVersion> {
        private final ClientProfile profile;

        private JavaVersionConverter(ClientProfile clientProfile) {
            this.profile = clientProfile;
        }

        public String toString(JavaHelper.JavaVersion javaVersion) {
            if (javaVersion == null) {
                return "Unknown";
            }
            String string = "";
            if (javaVersion.version == this.profile.getRecommendJavaVersion()) {
                string = "[RECOMMENDED]";
            }
            return "Java %d b%d %s".formatted(javaVersion.version, javaVersion.build, string);
        }

        public JavaHelper.JavaVersion fromString(String string) {
            return null;
        }
    }

    private static class JavaVersionCellFactory
    implements Callback<ListView<JavaHelper.JavaVersion>, ListCell<JavaHelper.JavaVersion>> {
        private final StringConverter<JavaHelper.JavaVersion> converter;

        public JavaVersionCellFactory(StringConverter<JavaHelper.JavaVersion> stringConverter) {
            this.converter = stringConverter;
        }

        public ListCell<JavaHelper.JavaVersion> call(ListView<JavaHelper.JavaVersion> listView) {
            return new JavaVersionListCell(this.converter);
        }
    }

    private static class JavaVersionListCell
    extends ListCell<JavaHelper.JavaVersion> {
        private final StringConverter<JavaHelper.JavaVersion> converter;

        public JavaVersionListCell(StringConverter<JavaHelper.JavaVersion> stringConverter) {
            this.converter = stringConverter;
        }

        protected void updateItem(JavaHelper.JavaVersion javaVersion, boolean bl) {
            super.updateItem((Object)javaVersion, bl);
            if (bl || javaVersion == null) {
                this.setText(null);
                this.setTooltip(null);
            } else {
                this.setText(this.converter.toString((Object)javaVersion));
                Tooltip tooltip = new Tooltip(javaVersion.jvmDir.toString());
                tooltip.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_BOTTOM_LEFT);
                this.setTooltip(tooltip);
            }
        }
    }
}

