/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings.components;

import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.utils.helper.LogHelper;

public class LanguageSelectorComponent {
    private final JavaFXApplication application;
    private final ComboBox<RuntimeSettings.LAUNCHER_LOCALE> comboBox;

    public LanguageSelectorComponent(JavaFXApplication javaFXApplication, Pane pane) {
        this.application = javaFXApplication;
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)pane, "#languageCombo");
        this.comboBox.getItems().clear();
        this.comboBox.setConverter((StringConverter)new ThemeConverter());
        for (RuntimeSettings.LAUNCHER_LOCALE lAUNCHER_LOCALE : RuntimeSettings.LAUNCHER_LOCALE.values()) {
            this.comboBox.getItems().add((Object)lAUNCHER_LOCALE);
        }
        this.comboBox.getSelectionModel().select((Object)Objects.requireNonNullElse(javaFXApplication.runtimeSettings.locale, RuntimeSettings.LAUNCHER_LOCALE.ENGLISH));
        this.comboBox.setOnAction(actionEvent -> {
            RuntimeSettings.LAUNCHER_LOCALE lAUNCHER_LOCALE = (RuntimeSettings.LAUNCHER_LOCALE)((Object)((Object)this.comboBox.getValue()));
            if (lAUNCHER_LOCALE == null) {
                return;
            }
            if (lAUNCHER_LOCALE == javaFXApplication.runtimeSettings.locale) {
                return;
            }
            try {
                javaFXApplication.updateLocaleResources(lAUNCHER_LOCALE.name);
                javaFXApplication.runtimeSettings.locale = lAUNCHER_LOCALE;
                javaFXApplication.gui.reload();
            }
            catch (Exception exception) {
                LogHelper.error(exception);
            }
        });
    }

    private class ThemeConverter
    extends StringConverter<RuntimeSettings.LAUNCHER_LOCALE> {
        private ThemeConverter() {
        }

        public String toString(RuntimeSettings.LAUNCHER_LOCALE lAUNCHER_LOCALE) {
            if (lAUNCHER_LOCALE == null) {
                return "Unknown";
            }
            return LanguageSelectorComponent.this.application.getTranslation(String.format("runtime.themes.%s", lAUNCHER_LOCALE.displayName), lAUNCHER_LOCALE.displayName);
        }

        public RuntimeSettings.LAUNCHER_LOCALE fromString(String string) {
            return null;
        }
    }
}

