/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings.components;

import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.utils.helper.LogHelper;

public class ThemeSelectorComponent {
    private final JavaFXApplication application;
    private final ComboBox<RuntimeSettings.LAUNCHER_THEME> comboBox;

    public ThemeSelectorComponent(JavaFXApplication javaFXApplication, Pane pane) {
        this.application = javaFXApplication;
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)pane, "#themeCombo");
        this.comboBox.getItems().clear();
        this.comboBox.setConverter((StringConverter)new ThemeConverter());
        if (javaFXApplication.isThemeSupport()) {
            for (RuntimeSettings.LAUNCHER_THEME lAUNCHER_THEME : RuntimeSettings.LAUNCHER_THEME.values()) {
                this.comboBox.getItems().add((Object)lAUNCHER_THEME);
            }
        } else {
            this.comboBox.getItems().add((Object)RuntimeSettings.LAUNCHER_THEME.COMMON);
        }
        this.comboBox.getSelectionModel().select((Object)Objects.requireNonNullElse(javaFXApplication.runtimeSettings.theme, RuntimeSettings.LAUNCHER_THEME.COMMON));
        this.comboBox.setOnAction(actionEvent -> {
            RuntimeSettings.LAUNCHER_THEME lAUNCHER_THEME = (RuntimeSettings.LAUNCHER_THEME)((Object)((Object)this.comboBox.getValue()));
            if (lAUNCHER_THEME == null || lAUNCHER_THEME == RuntimeSettings.LAUNCHER_THEME.COMMON && javaFXApplication.runtimeSettings.theme == null) {
                return;
            }
            if (lAUNCHER_THEME == javaFXApplication.runtimeSettings.theme) {
                return;
            }
            javaFXApplication.runtimeSettings.theme = lAUNCHER_THEME;
            try {
                javaFXApplication.gui.reload();
            }
            catch (Exception exception) {
                LogHelper.error(exception);
            }
        });
    }

    private class ThemeConverter
    extends StringConverter<RuntimeSettings.LAUNCHER_THEME> {
        private ThemeConverter() {
        }

        public String toString(RuntimeSettings.LAUNCHER_THEME lAUNCHER_THEME) {
            if (lAUNCHER_THEME == null) {
                return "Unknown";
            }
            return ThemeSelectorComponent.this.application.getTranslation(String.format("runtime.themes.%s", lAUNCHER_THEME.displayName), lAUNCHER_THEME.displayName);
        }

        public RuntimeSettings.LAUNCHER_THEME fromString(String string) {
            return null;
        }
    }
}

