/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import java.util.ArrayList;
import java.util.List;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.base.profiles.PlayerProfile;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.base.request.auth.password.AuthAESPassword;
import pro.gravit.launcher.base.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.base.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.base.request.auth.password.AuthTOTPPassword;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.utils.helper.SecurityHelper;

public class AuthService {
    private final LauncherConfig config = Launcher.getConfig();
    private final JavaFXApplication application;
    private AuthRequestEvent rawAuthResult;
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;

    public AuthService(JavaFXApplication javaFXApplication) {
        this.application = javaFXApplication;
    }

    public AuthRequest.AuthPasswordInterface makePassword(String string) {
        if (this.config.passwordEncryptKey != null) {
            try {
                return new AuthAESPassword(this.encryptAESPassword(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new AuthPlainPassword(string);
    }

    public AuthRequest.AuthPasswordInterface make2FAPassword(AuthRequest.AuthPasswordInterface authPasswordInterface, String string) {
        Auth2FAPassword auth2FAPassword = new Auth2FAPassword();
        auth2FAPassword.firstPassword = authPasswordInterface;
        auth2FAPassword.secondPassword = new AuthTOTPPassword();
        ((AuthTOTPPassword)auth2FAPassword.secondPassword).totp = string;
        return auth2FAPassword;
    }

    public List<AuthRequest.AuthPasswordInterface> getListFromPassword(AuthRequest.AuthPasswordInterface authPasswordInterface) {
        if (authPasswordInterface instanceof Auth2FAPassword) {
            Auth2FAPassword auth2FAPassword = (Auth2FAPassword)authPasswordInterface;
            ArrayList<AuthRequest.AuthPasswordInterface> arrayList = new ArrayList<AuthRequest.AuthPasswordInterface>();
            arrayList.add(auth2FAPassword.firstPassword);
            arrayList.add(auth2FAPassword.secondPassword);
            return arrayList;
        }
        if (authPasswordInterface instanceof AuthMultiPassword) {
            AuthMultiPassword authMultiPassword = (AuthMultiPassword)authPasswordInterface;
            return authMultiPassword.list;
        }
        ArrayList<AuthRequest.AuthPasswordInterface> arrayList = new ArrayList<AuthRequest.AuthPasswordInterface>(1);
        arrayList.add(authPasswordInterface);
        return arrayList;
    }

    public AuthRequest.AuthPasswordInterface getPasswordFromList(List<AuthRequest.AuthPasswordInterface> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 2) {
            Auth2FAPassword auth2FAPassword = new Auth2FAPassword();
            auth2FAPassword.firstPassword = list.get(0);
            auth2FAPassword.secondPassword = list.get(1);
            return auth2FAPassword;
        }
        AuthMultiPassword authMultiPassword = new AuthMultiPassword();
        authMultiPassword.list = list;
        return authMultiPassword;
    }

    public AuthRequest makeAuthRequest(String string, AuthRequest.AuthPasswordInterface authPasswordInterface, String string2) {
        return new AuthRequest(string, authPasswordInterface, string2, false, this.application.isDebugMode() ? AuthRequest.ConnectTypes.API : AuthRequest.ConnectTypes.CLIENT);
    }

    private byte[] encryptAESPassword(String string) throws Exception {
        return SecurityHelper.encrypt(Launcher.getConfig().passwordEncryptKey, string);
    }

    public void setAuthResult(String string, AuthRequestEvent authRequestEvent) {
        this.rawAuthResult = authRequestEvent;
        if (authRequestEvent.oauth != null) {
            Request.setOAuth(string, authRequestEvent.oauth);
        }
    }

    public void setAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability) {
        this.authAvailability = authAvailability;
    }

    public GetAvailabilityAuthRequestEvent.AuthAvailability getAuthAvailability() {
        return this.authAvailability;
    }

    public boolean isFeatureAvailable(String string) {
        return this.authAvailability.features != null && this.authAvailability.features.contains(string);
    }

    public String getUsername() {
        if (this.rawAuthResult == null || this.rawAuthResult.playerProfile == null) {
            return "Player";
        }
        return this.rawAuthResult.playerProfile.username;
    }

    public String getMainRole() {
        if (this.rawAuthResult == null || this.rawAuthResult.permissions == null || this.rawAuthResult.permissions.getRoles() == null || this.rawAuthResult.permissions.getRoles().isEmpty()) {
            return "";
        }
        return this.rawAuthResult.permissions.getRoles().get(0);
    }

    public boolean checkPermission(String string) {
        if (this.rawAuthResult == null || this.rawAuthResult.permissions == null) {
            return false;
        }
        return this.rawAuthResult.permissions.hasPerm(string);
    }

    public boolean checkDebugPermission(String string) {
        return this.application.isDebugMode() || !this.application.guiModuleConfig.disableDebugPermissions && this.checkPermission("launcher.debug." + string);
    }

    public PlayerProfile getPlayerProfile() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.playerProfile;
    }

    public String getAccessToken() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.accessToken;
    }

    public void exit() {
        this.rawAuthResult = null;
    }
}

